/**
 * Compile options:
 * Board : Generic STM32F1 -> BluePill F103C8 OR BlackPill F103C8
 * USART-> Enabled
 * USBCDC -> Enabled
 * Optimized : Anything without LTO
 * C runtime: Newlib nano
 * Bootloader : HID 2.2
 */

/* Includes */
#include <STM32FreeRTOS.h>
#include <RCSwitch.h>

#define RX433PIN PB6

String someName;

/* Remote transceiver */
RCSwitch remote433 = RCSwitch();

void setup()
{
  //Debug console
  Serial.begin(9600);
  // wait for serial port to connect. Needed for native USB, on LEONARDO, MICRO, YUN, and other 32u4 based boards.
  while (!Serial);

  //config BUILTIN lED for output
  pinMode(LED_BUILTIN , OUTPUT);
  //turns it off
  digitalWrite(LED_BUILTIN, HIGH);

  remote433.enableReceive(RX433PIN);
  Serial.print("Starting...");
}


void loop()
{
  if(remote433.available())
  {
    //digitalToggle(LED_BUILTIN);
    Serial.print("Received ");
    Serial.print( remote433.getReceivedValue() );
    Serial.print(" / ");
    Serial.print( remote433.getReceivedBitlength() );
    Serial.print("bit ");
    Serial.print("Protocol: ");
    Serial.println( remote433.getReceivedProtocol() );

    remote433.resetAvailable();
  }
}
