'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';
const RESOURCES = {
  "assets/AssetManifest.json": "bc8fd47b18a1ef40f214b8665239090f",
"assets/FontManifest.json": "dc3d03800ccca4601324923c0b1d6d57",
"assets/fonts/MaterialIcons-Regular.otf": "1288c9e28052e028aba623321f7826ac",
"assets/images/ACTUALIZAR%2520DATOS.png": "377c80cb110eb6771a7f595c0241e929",
"assets/images/actualizar_datos.png": "238d350a921e224deb7dcea55149e0a8",
"assets/images/ADECUACION.png": "d0a88847c38f3dd1ecf0deea3f4cd29b",
"assets/images/AGOSTAMIENTO.png": "dce49d313ba1bdcbdfcc1c281fb261bd",
"assets/images/APORQUE.png": "3b8e5f0c42def485be23fe0ef04127e5",
"assets/images/biodiesel-1-bicubic.jpg": "a19ca4087c4d7d89177b1e944b184a1a",
"assets/images/bioetanol.gif": "eecc66dd79eb1f1313bb8af142ed7918",
"assets/images/bolsa-de-dinero.png": "b6454111ecda8f7330c4cf06c0015b69",
"assets/images/calendario.png": "0d911659e21c01e9a0b78898e815d406",
"assets/images/camarones.jpg": "4629d0e6bb1da9957eeec0654fc0cd7f",
"assets/images/CONFIGURACI%25C3%2593N.png": "353dd8b5d90696e4f6c3648a7f269862",
"assets/images/CONSULTAS.png": "0a9928e1707af4e41db06ebdbf6d2d15",
"assets/images/CONTROLDEMALEZAS.png": "356389a4bcf6236f2273367ce9783be3",
"assets/images/CRONOL%25C3%2593GICO.png": "b6d2177a31797aab3e99e3fff56fb69e",
"assets/images/cultivos.png": "52c87c4221ad81a8b7a5f9e4ac6cc807",
"assets/images/derivados-cana.jpg": "062aec601bdb3481a1b1197aa8c3c0e7",
"assets/images/derivados-palma.jpg": "4da588a9e15521cf140be74a7305a508",
"assets/images/Dunes-Back-1.png": "74de042e476b56bb09ff7e3da0786eb6",
"assets/images/ENCALLE.png": "c1cbe8faba523dda4c735c134e4ec605",
"assets/images/ENTRADA%2520DE%2520CA%25C3%2591A.png": "46cbfb2ebb8c5017f32a88e2cf6d18a5",
"assets/images/estadisticas.png": "89c854e87bc9e8fdbfc428a14b37bb56",
"assets/images/FERTILIZACION.png": "b659ac19d6a540a6ee6f5473904a714e",
"assets/images/INFORME%2520DE%2520PRODUCCI%25C3%2593N.png": "1159846358a1e3cf7d58e8775ca4c8a5",
"assets/images/liq.png": "f877d66e64f8d7d78290bf219bd7c3ae",
"assets/images/LIQUIDACI%25C3%2593N%2520CA%25C3%2591A.png": "fa183a6aeba99c43e8ded9e3f22c515c",
"assets/images/lista.pdf": "23c723d92418ef90354a409ac259d97c",
"assets/images/login1.jpg": "2c5ef84e9527a2c3f2e90f76f0463414",
"assets/images/logo.svg": "bf096b226bc05ded332ed41f15878366",
"assets/images/logo2.jpg": "e3a3572ff5cd628d3ed5f81eed91185f",
"assets/images/logo_principal.JPG": "115238b152ec3a5c0e925d1bccd1d300",
"assets/images/logo_principal.png": "2eba766c64f1348ee24ff834e46a34b9",
"assets/images/lupa.png": "f4534f7b1e2ecb89ed92b691fdec82ad",
"assets/images/menu.png": "9bf9b44cf64d15b923a3ab00d3d02a77",
"assets/images/PLAGASYENFERMEDADES.png": "725b327677fb5af9b095565964de1ef0",
"assets/images/PLANTILLA.png": "d2485319c6fcabf6fc307ec453003078",
"assets/images/PLANTILLAF.png": "59b750887deb56a1b8e0287a21c03397",
"assets/images/RECOMENDACI%25C3%2593N.png": "7b701e4a967dfe161f9b1f02a40b2813",
"assets/images/RENOVACION.png": "1bd25c3300693784fd831491c1c0b12b",
"assets/images/RENOVACION1.png": "15f12c108913519a72eedbe73132c981",
"assets/images/RESIEMBRA.png": "6caf724a75c275761f1d7673990aa51a",
"assets/images/RIEGO%2520GERMINACI%25C3%2593N%2520Y%2520LEVANTE.png": "3880b91adf731bdd1862f903871f03c2",
"assets/images/RIEGOGERMINACION.png": "3880b91adf731bdd1862f903871f03c2",
"assets/images/RIEGOLEVANTE.png": "ae7a4492a2664d1a9466b8ac0ee3ee33",
"assets/images/ROTURACION.png": "4716cc8142346f1516654c1be3e45e59",
"assets/images/SIEMBRA.png": "d2485319c6fcabf6fc307ec453003078",
"assets/images/SOCAS.png": "d3ed77991971fab1a3f026b7984924dc",
"assets/images/SOCASF.png": "079000c8e918e8f7ac71f1e2525f8814",
"assets/images/sugar-cane.png": "04afc846ecac2d1fdfaf017dbf8d3444",
"assets/images/titulo.PNG": "3fe859dbcb79be3b6f340c4202e5a8b2",
"assets/images/titulop.png": "3fe859dbcb79be3b6f340c4202e5a8b2",
"assets/images/tractor.png": "11d40d035ff553aaa4a1c30f8b879faa",
"assets/images/tractor1.png": "ce77045d3bd55505d3f3ee8a2686535a",
"assets/images/tractor_verde.png": "f660a1b28829f2162e5dc2b6cfa36474",
"assets/images/unnamed.png": "ede49c774d05b6f1293df4f52b9960c6",
"assets/images/vagon-de-carga.png": "a50719c28801c0228e8ccd784a29c9ac",
"assets/images/vagon-gris.png": "3597daf03effa27a55f3911cf1a96f93",
"assets/images/vagon.png": "a00df8a7f9759fccc3bcfbf2bc5e0296",
"assets/NOTICES": "0857d8a3fc0c39fe8d2ba016fee58a55",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "6d342eb68f170c97609e9da345464e5e",
"assets/packages/progress_dialog/assets/double_ring_loading_io.gif": "e5b006904226dc824fdb6b8027f7d930",
"assets/packages/rflutter_alert/assets/images/2.0x/close.png": "abaa692ee4fa94f76ad099a7a437bd4f",
"assets/packages/rflutter_alert/assets/images/2.0x/icon_error.png": "2da9704815c606109493d8af19999a65",
"assets/packages/rflutter_alert/assets/images/2.0x/icon_info.png": "612ea65413e042e3df408a8548cefe71",
"assets/packages/rflutter_alert/assets/images/2.0x/icon_success.png": "7d6abdd1b85e78df76b2837996749a43",
"assets/packages/rflutter_alert/assets/images/2.0x/icon_warning.png": "e4606e6910d7c48132912eb818e3a55f",
"assets/packages/rflutter_alert/assets/images/3.0x/close.png": "98d2de9ca72dc92b1c9a2835a7464a8c",
"assets/packages/rflutter_alert/assets/images/3.0x/icon_error.png": "15ca57e31f94cadd75d8e2b2098239bd",
"assets/packages/rflutter_alert/assets/images/3.0x/icon_info.png": "e68e8527c1eb78949351a6582469fe55",
"assets/packages/rflutter_alert/assets/images/3.0x/icon_success.png": "1c04416085cc343b99d1544a723c7e62",
"assets/packages/rflutter_alert/assets/images/3.0x/icon_warning.png": "e5f369189faa13e7586459afbe4ffab9",
"assets/packages/rflutter_alert/assets/images/close.png": "13c168d8841fcaba94ee91e8adc3617f",
"assets/packages/rflutter_alert/assets/images/icon_error.png": "f2b71a724964b51ac26239413e73f787",
"assets/packages/rflutter_alert/assets/images/icon_info.png": "3f71f68cae4d420cecbf996f37b0763c",
"assets/packages/rflutter_alert/assets/images/icon_success.png": "8bb472ce3c765f567aa3f28915c1a8f4",
"assets/packages/rflutter_alert/assets/images/icon_warning.png": "ccfc1396d29de3ac730da38a8ab20098",
"favicon.JPG": "115238b152ec3a5c0e925d1bccd1d300",
"firebase-messaging-sw.js": "1b81a3e11f2b0ae0c8703269f79ed4c3",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"index.html": "af516da764cc58705245fdec0d9e64f6",
"/": "af516da764cc58705245fdec0d9e64f6",
"main.dart.js": "97c4e568f1165aa2c429d8d98ee4cab0",
"manifest.json": "ef745c11eb1fba35dd5ce7f3633531b3",
"version.json": "92116d5d8c707b7d05c2fae38db17f5e"
};

// The application shell files that are downloaded before a service worker can
// start.
const CORE = [
  "/",
"main.dart.js",
"index.html",
"assets/NOTICES",
"assets/AssetManifest.json",
"assets/FontManifest.json"];
// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value + '?revision=' + RESOURCES[value], {'cache': 'reload'})));
    })
  );
});

// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});

// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache.
        return response || fetch(event.request).then((response) => {
          cache.put(event.request, response.clone());
          return response;
        });
      })
    })
  );
});

self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});

// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}

// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
