use serde_derive::{Deserialize, Serialize};

pub type id_rol = String;

#[derive(Deserialize, Serialize, Clone, Debug)]
enum Identificacion{
    Ninguna,
    NIT(String),
    Cedula(String),
    CedulaExtranjeria(String),
}

#[derive(Deserialize, Serialize, Clone, Debug)]
struct OldUser{
    usuario_id: String,
    usuario: String,
    nombre_completo: String,
    clave_acceso: String,
    telefono1: String,
    telefono2: String,
    telefono3: String,
    email: String,
    email_alternativo: String,
    identificacion: Identificacion,
    propietario_id: Option<String>,
    reintentos_acceso: usize,
    bloqueo: bool,
    roles: Vec<id_rol>,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
}

#[derive(Deserialize, Serialize, Clone, Debug)]
struct NewUser{
    usuario_id: String,
    usuario: String,
    nombre_completo: String,
    clave_acceso: String,
    telefono1: String,
    telefono2: String,
    telefono3: String,
    email: String,
    email_alternativo: String,
    nits: Vec<String>,
    reintentos_acceso: usize,
    bloqueo: bool,
    roles: Vec<id_rol>,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
}

pub fn recover_structure(db : &sled::Db) {

    

    println!("Conversion Users");
    //Adicion de los campos email y distribuidor_id
    for item in db.scan_prefix("User"){
	
	if let Ok((key,raw_data)) = item {
	    println!("Convirtiendo registro {:?}",std::str::from_utf8(&key).unwrap());
	    match rmp_serde::from_read_ref::<_,OldUser>(&raw_data){
		Ok(old_s)=>{
		    let new_s = NewUser{
			usuario_id:old_s.usuario_id,
			usuario:old_s.usuario,
			nombre_completo:old_s.nombre_completo,
			clave_acceso:old_s.clave_acceso,
			telefono1:old_s.telefono1,
			telefono2:old_s.telefono2,
			telefono3:old_s.telefono3,
			email:old_s.email,
			email_alternativo:old_s.email_alternativo,
			nits:vec![],
			reintentos_acceso:old_s.reintentos_acceso,
			bloqueo:old_s.bloqueo,
			roles:old_s.roles,
			creation_stamp:old_s.creation_stamp,
			created_by:old_s.created_by,
			modification_stamp:old_s.modification_stamp,
			modified_by:old_s.modified_by,
		    };
		    
		    match rmp_serde::to_vec(&new_s){
			Ok(new_raw)=>{

			    match db.insert( key.clone(), new_raw){
				Ok(_) => println!("Conversion Ok!"),
				Err(_why)=> println!("Falla la escribir nuevo registro en DB para {:?}: {}",key,_why),
			    }
			    
			},
			Err(_why)=> println!("Falla la intentar serializar nuevo registro para {:?}: {}",key,_why),
		    };

		    
		},
		Err(_why) => println!("Falla la intentar desserializar registro {:?}: {}",key,_why),
	    }		
	}
    }
    
}
