use acme_lib::{Error, Directory, DirectoryUrl};
use acme_lib::persist::FilePersist;
use acme_lib::create_p384_key;

pub fn request_cert(account: &str, host_name: &str) -> Result<(), Error> {

    let account :String = account.to_string();
    let host_name :String = host_name.to_string();
   
    
    println!("Starting TLS certificate generarion request....");
    
    // Use DirectoryUrl::LetsEncrypStaging for dev/testing.
    let url = DirectoryUrl::LetsEncrypt;
    
    // Save/load keys and certificates to current dir.
    let persist = FilePersist::new("./tls");
    
    // Create a directory entrypoint.
    let dir = Directory::from_url(persist, url)?;
    
    // Reads the private account key from persistence, or
    // creates a new one before accessing the API to establish
    // that it's there.
    let acc = dir.account(&account)?;
    
    // Order a new TLS certificate for a domain.
    let mut ord_new = acc.new_order(&host_name, &[])?;
    
    // If the ownership of the domain(s) have already been
    // authorized in a previous order, you might be able to
    // skip validation. The ACME API provider decides.
    let ord_csr = loop {
	// are we done?
	if let Some(ord_csr) = ord_new.confirm_validations() {
	    break ord_csr;
	}
	
	// Get the possible authorizations (for a single domain
	// this will only be one element).
	let auths = ord_new.authorizations()?;
	
	// For HTTP, the challenge is a text file that needs to
	// be placed in your web server's root:
	//
	// /var/www/.well-known/acme-challenge/<token>
	//
	// The important thing is that it's accessible over the
	// web for the domain(s) you are trying to get a
	// certificate for:
	//
	// http://mydomain.io/.well-known/acme-challenge/<token>
	let chall = auths[0].http_challenge();
	
	// The token is the filename.
	let token = chall.http_token();
	let path = format!("./tls/{}", token);
	
	// The proof is the contents of the file
	let proof = chall.http_proof();
	
	println!("Writing certificate proof");
	
	std::fs::write(path, proof).unwrap_or(());	
	
	// Here you must do "something" to place
	// the file/contents in the correct place.
	// update_my_web_server(&path, &proof);
	
	// After the file is accessible from the web, the calls
	// this to tell the ACME API to start checking the
	// existence of the proof.
	//
	// The order at ACME will change status to either
	// confirm ownership of the domain, or fail due to the
	// not finding the proof. To see the change, we poll
	// the API with 5000 milliseconds wait between.
	
	println!("Awaiting for external validation");
	chall.validate(5000)?;
	
	// Update the state against the ACME API.
	ord_new.refresh()?;
    };

    println!("Ownership of domain proven!!! Writing certificate to disk");
    
    // Ownership is proven. Create a private key for
    // the certificate. These are provided for convenience, you
    // can provide your own keypair instead if you want.
    let pkey_pri = create_p384_key();
    
    // Submit the CSR. This causes the ACME provider to enter a
    // state of "processing" that must be polled until the
    // certificate is either issued or rejected. Again we poll
    // for the status change.
    let ord_cert =
	ord_csr.finalize_pkey(pkey_pri, 5000)?;
    
    // Now download the certificate. Also stores the cert in
    // the persistence.
    let _cert = ord_cert.download_and_save_cert()?;
    
    Ok(())
}
