use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use crate::errors;
use super::usuario::Usuario;
use super::{Storable};
use crate::{audit, store};
use std::default::Default;
use std::hash::{Hash, Hasher};
audit!{TrazabilidadPlataforma}//macro
store!{TrazabilidadPlataforma,id,vec![],vec![]}

#[derive(Deserialize, Serialize,Clone)]
pub struct TrazabilidadPlataforma{
    
    id: String,
    usuario_id : String,
    modificado_por:String,
    accion: String,
    objeto_modificado : ObjetoModificado,
    campo_modificado:String,
    valor_antes:String,
    valor_despues:String,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,

}

#[derive(Deserialize, Serialize,Clone)]
pub enum ObjetoModificado{
    Usuario{id:String},
    Rol{id:String}
}
impl std::convert::From<ObjetoModificado> for String{
    fn from(parametro:ObjetoModificado)->String{
        match parametro {
            
            ObjetoModificado::Usuario{id}=>{format!("Usuario({})",id)},
            ObjetoModificado::Rol{id}=>{format!("Rol({})",id)},

        }
    }
}

impl TrazabilidadPlataforma{
    pub fn new (usuario: &Usuario, usuario_modifica:&str,accion:&str,objeto_modificado: ObjetoModificado,campo_modificado: &str,valor_antes: &str,valor_despues: &str) -> Self{
        
        let now = crate::utils::now_microseconds();
        Self{
            id:Default::default(),
            usuario_id : usuario.id(),
            modificado_por: usuario_modifica.to_string(),
            accion: accion.to_string(),
            objeto_modificado : objeto_modificado,
            campo_modificado:campo_modificado.to_string(),
            valor_antes:valor_antes.to_string(),
            valor_despues:valor_despues.to_string(),
            creation_stamp: now,
            created_by: usuario.id(),
            modification_stamp: now,
            modified_by: usuario.id(),
        
        }
    }

    pub fn consulta(db:&std::sync::Arc<sled::Db> ,ini:i64,fin:i64) -> Vec <Self>{

        TrazabilidadPlataforma::scan(db,|row|{
            crate::utils::ientre_rango(row.creation_stamp,ini,fin)
            }
        )

    }

    pub fn usuario_id(&self)-> String{
        self.usuario_id.to_string()
    }

    pub fn objeto_modificado(&self)->ObjetoModificado{
        self.objeto_modificado.clone()
    }

    pub fn modificado_por(&self)->String{
        self.modificado_por.to_string()

    }

    pub fn campo_modificado(&self)->String{
        self.campo_modificado.to_string()

    }

    pub fn accion(&self)->String{
        self.accion.to_string()

    }

    pub fn valor_antes(&self)->String{
        self.valor_antes.to_string()
    }

    pub fn valor_despues(&self)->String{
        self.valor_despues.to_string()
    }
}