use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use crate::errors;
use super::usuario::Usuario;
use super::{Storable};
use crate::{audit, store};
audit!{Sesion}
store!{Sesion, id, vec![], vec![]}

#[derive(Deserialize, Serialize, Debug, Clone)]
pub struct Sesion{
    id: String,
    usuario: Usuario,
    valid_until: i64,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
}

impl std::default::Default for Sesion {
    fn default () -> Self {
	Self{
	    id: Self::generate_id(),
	    usuario: Default::default(),
	    valid_until: Default::default(),
	    creation_stamp: Utc::now().timestamp(),
	    created_by: Default::default(),
	    modification_stamp: Utc::now().timestamp(),
	    modified_by: Default::default(),

	}
    }
}

impl Sesion {
    pub fn new(for_user: &Usuario) -> Self {

	let validity = Utc::now();
	validity.checked_add_signed(chrono::Duration::days(1));
	
	let mut nuevo : Self = Default::default();
	
	nuevo.valid_until = validity.timestamp();
	nuevo.usuario = for_user.clone();
	nuevo.created_by = for_user.id();
	nuevo.modified_by = for_user.id();

	nuevo

    }

    pub fn sesion_anonima() -> Self {

	let validity = Utc::now();
	let now = Utc::now();
	let usuario_anonimo = Usuario::usuario_anonimo();

	let validity = Utc::now();
	validity.checked_add_signed(chrono::Duration::days(1));
	
	let mut nuevo_anonimo : Self = Default::default();
	
	nuevo_anonimo.valid_until = validity.timestamp();
	nuevo_anonimo.usuario = usuario_anonimo.clone();
	nuevo_anonimo.created_by = usuario_anonimo.id();
	nuevo_anonimo.modified_by = usuario_anonimo.id();

	nuevo_anonimo

    }

    pub fn usuario(&self) -> Usuario {
	self.usuario.clone()
    }

    pub fn check_session_id_valid(db : &sled::Db, session_id: &str) -> bool {

	let now_timestamp = Utc::now().timestamp();
	
	if let Some(found_sess) = Sesion::scan_first(db, |item: &Sesion| item.id == session_id) {

	    (found_sess.valid_until - now_timestamp) > 0
	    
	} else {

	    false
	    
	}
	
    }

    pub fn clear_all_sessions(db : &sled::Db, to_exclude: Option<&str>) -> Result<(), Box<dyn std::error::Error>>{
	    
	for session in Sesion::scan(db,|_ses: &Sesion| true){

	    if let Some(exclude_session_id) = to_exclude{

		if exclude_session_id != session.id() {
		    println!("session to delete with exclusion: {:?}",session);
		    session.delete(db)?;
		}
		
	    } else {

		println!("session to delete: {:?}",session);
		session.delete(db)?;
		
	    }
	    
	}

	Ok(())
	
    }
}
