use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use errors::{StorableError};
use crate::errors;
use super::{
    usuario::Usuario,
    objetos_seguridad::ObjetosSeguridad,
    sesion::Sesion,
};
use super::{Auditable, Storable};
use crate::{audit, store};
use std::default::Default;

audit!{Rol}
store!{Rol, id, vec![], vec![]}

#[derive(Deserialize, Serialize, Debug, Clone, PartialEq)]
pub struct Rol{
    id: String,
    nombre: String,
    descripcion: String,
    objetos: Vec<ObjetosSeguridad>,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
}

impl std::default::Default for Rol {
    fn default () -> Self {
	Self{
	    id: Self::generate_id(),
	    nombre: Default::default(),
	    descripcion: Default::default(),
	    objetos: Default::default(),
	    creation_stamp: crate::utils::now_microseconds(),
	    created_by: Default::default(),
	    modification_stamp: crate::utils::now_microseconds(),
	    modified_by: Default::default(),
	}
    }
}

/*impl Storable for Rol{
    fn check_before_store(&self, _db : &sled::Db) -> Result<(), Box<dyn std::error::Error>>{

	//Encuentra si el nombre de rol esta repetido
	if let Some(rol) = self.scan_first(db, |x| self.nombre() == &x.nombre()){
	    Err(Box::new(StorableError::DuplicateRecord))
	}else{
	    Ok(())
	}
    }
}*/

impl Rol {

    pub fn new(nombre: &str, descripcion: &str) -> Self {

	let mut nuevo :Self = Default::default();

	nuevo.nombre = nombre.to_string();
	nuevo.descripcion = descripcion.to_string();
	
	nuevo

    }

    fn check_before_store(&self, _db : &sled::Db) -> Result<(), Box<dyn std::error::Error>>{

	//Encuentra si el nombre de rol esta repetido
	if let Some(rol) = Self::scan_first(_db, |x| self.nombre() == x.nombre()){
	    Err(Box::new(StorableError::DuplicateRecord("Rol".to_string(), self.nombre())))
	}else{
	    Ok(())
	}
    }
    
    pub fn nombre(&self) -> String{
	self.nombre.to_string()
    }

    pub fn set_nombre(&mut self, valor: &str){
	self.nombre = valor.to_string();
    }

    pub fn descripcion(&self)-> String{
	self.descripcion.to_string()
    }

    pub fn set_descripcion(&mut self, valor: &str){
	self.descripcion = valor.to_string();
    }

    pub fn objetos(&self) -> &Vec<ObjetosSeguridad>{
	&self.objetos
    }
    
    pub fn agregar_objetos(&mut self, listado: &mut Vec<ObjetosSeguridad>){
	self.objetos.append(listado);
	self.objetos.sort_by(|a,b| a.cmp(&b) );
	self.objetos.dedup();

    }

    pub fn remover_objetos(&mut self, listado: &Vec<ObjetosSeguridad>){
	self.objetos = self.objetos.iter().filter_map(|x| if !listado.contains(x) { Some(x.clone()) } else { None } ).collect();
	self.objetos.dedup();
    }

}
