use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use crate::errors;
use super::{
    usuario::Usuario,
    sesion::Sesion,
};
use super::{Auditable, Storable};
use crate::{audit, store};
use std::default::Default;
audit!{RefreshToken}
store!{RefreshToken, id, vec![], vec![]}

#[derive(Deserialize, Serialize, Debug, Clone)]
pub struct RefreshToken{
    id: String,
    usuario: Usuario,
    clave_dinamica: String,
    valid_until: i64,
    sesion: Sesion,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
}

impl std::default::Default for RefreshToken {
    fn default () -> Self {
	Self{
	    id: Self::generate_id(),
	    usuario: Default::default(),
	    clave_dinamica: Default::default(),
	    valid_until: Default::default(),
	    sesion: Default::default(),
	    creation_stamp: Utc::now().timestamp(),
	    created_by: Default::default(),
	    modification_stamp: Utc::now().timestamp(),
	    modified_by: Default::default(),
	}
    }
}


impl RefreshToken {
    pub fn new(for_user: &Usuario, clave_dinamica:&str, sesion: &Sesion) -> Self {

	let validity = Utc::now();

	validity.checked_add_signed(chrono::Duration::days(1));

	let mut nuevo : Self = Default::default();

	nuevo.clave_dinamica = clave_dinamica.to_string();
	nuevo.valid_until = validity.timestamp();
	nuevo.usuario = for_user.clone();
	nuevo.sesion = sesion.clone(); 
	
	nuevo
    }


    pub fn usuario(&self) -> Usuario {
	self.usuario.clone()
    }

    pub fn clave_dinamica(&self) -> String {
	self.clave_dinamica.to_string()
    }

    pub fn sesion(&self) -> Sesion {
	self.sesion.clone()
    }


}
