use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use std::cmp::Ordering;
use crate::errors;
use super::{Auditable, Storable};
use crate::{audit,store};
use super::{sesion::Sesion,};
use super::usuario::Usuario;
audit!{Pqrs}
store!{Pqrs, id, vec![], vec![]}
use std::default::Default;

#[derive(Deserialize, Serialize, Clone, Debug)]
pub enum EstadoPqrs{
    Creado,
    EnProceso,
    Cerrado,
    Ninguno,
}

impl Default for EstadoPqrs{
    fn default() -> Self{
	Self::Ninguno
    }
}

impl std::fmt::Display for EstadoPqrs{
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
	match &self{
	    Self::Creado => write!(f, "Creado"),
	    Self::EnProceso => write!(f, "En Proceso"),
        Self::Cerrado => write!(f, "Cerrado"),
        Self::Ninguno => write!(f, "Ninguno"),
	}
    }
}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub enum TipoPqrs{
	Felicitacion,
    Solicitud,
    Queja,
    Reclamo,
    Ninguno,
}

impl Default for TipoPqrs{
    fn default() -> Self{
	Self::Ninguno
    }
}

impl std::fmt::Display for TipoPqrs{
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
	match &self{
		
		Self::Felicitacion => write!(f, "Felicitación"),
	    Self::Solicitud => write!(f, "Solicitud"),
	    Self::Queja => write!(f, "Queja"),
        Self::Reclamo => write!(f, "Reclamo"),
        Self::Ninguno => write!(f, "Ninguno"),
	}
    }
}

#[derive(Deserialize, Serialize, Debug, Clone)]
//#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct Pqrs{
    id: String,
	id_control: String,
    cod_hacienda: String,
    nombre_hacienda: String,
    telefono: String,
    email: String,
    tipo: TipoPqrs,
    asunto: String,
    mensaje: String,
    estado:EstadoPqrs,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
	usuario_creador: String,
}

impl Default for Pqrs {
    fn default () -> Self {
	Self{
	    id: Self::generate_id(),
		id_control: Default::default(),
	    cod_hacienda: Default::default(),
	    nombre_hacienda: Default::default(),
	    telefono: Default::default(),
	    email: Default::default(),
	    tipo: Default::default(),
	    asunto: Default::default(),
	    mensaje: Default::default(),
        estado: Default::default(),
	    creation_stamp: crate::utils::now_microseconds(),
	    created_by: Default::default(),
	    modification_stamp: crate::utils::now_microseconds(),
	    modified_by: Default::default(),
		usuario_creador: Default::default(),
	}
    }
}


impl Pqrs {
	


	pub fn new(
		id_control: &str,
		cod_hacienda: &str,
		nombre_hacienda: &str,
		telefono: &str,
		email: &str,
		asunto: &str,
		mensaje: &str,
		estado: EstadoPqrs,
		creation_stamp: i64, 
		usuario_creador: &str, ) -> Self {

			let mut aux : Self = Default::default();
			aux.id_control = id_control.to_string();
			aux.cod_hacienda = cod_hacienda.to_string();
			aux.nombre_hacienda = nombre_hacienda.to_string();
			aux.telefono = telefono.to_string();
			aux.email = email.to_string();
			aux.asunto = asunto.to_string();
			aux.mensaje = mensaje.to_string();
			aux.estado = estado;
			aux.creation_stamp = creation_stamp;
			aux.usuario_creador = usuario_creador.to_string();
			aux	
	}
	
	fn set_id(&mut self, i:&str){
		self.id = i.to_string();
	}

	pub fn set_id_control(&mut self, i:&str){
		self.id_control = i.to_string();
	}

	pub fn set_cod_hacienda(&mut self,i:&str){
		self.cod_hacienda = i.to_string();
	}

	pub fn set_nombre_hacienda(&mut self,i:&str){
		self.nombre_hacienda = i.to_string();
	}

	pub fn set_telefono(&mut self,i:&str){
		self.telefono = i.to_string();
	}

	pub fn set_email(&mut self,i:&str){
		self.email= i.to_string();
	}

    pub fn set_tipo(&mut self, i: TipoPqrs){
        self.tipo = i;
    }

	pub fn set_estado(&mut self, i: EstadoPqrs){
        self.estado = i;
    }

    pub fn set_asunto(&mut self,i:&str){
		self.asunto= i.to_string();
	}

    pub fn set_mensaje(&mut self,i:&str){
		self.mensaje= i.to_string();
	}

	pub fn set_modified_by(&mut self,i:&str){
		self.modified_by= i.to_string();
	}

	pub fn set_created_by(&mut self,i:&str){
		self.created_by= i.to_string();
	}

	pub fn set_modification_stamp(&mut self,i:i64){
		self.modification_stamp= i;
	}

	pub fn set_usuario_creador(&mut self,i:&str){
		self.usuario_creador = i.to_string();
	}
    
	// registro

	fn id(&self) -> String{
		self.id.to_string()
	}

	pub fn created_by(&self) -> String{
		self.created_by.to_string()
	}

	pub fn id_control(&self) -> String{
		self.id_control.to_string()
	}
	
    pub fn cod_hacienda(&self) -> String{
		self.cod_hacienda.to_string()
    }

	pub fn nombre_hacienda(&self) -> String{
		self.nombre_hacienda.to_string()
	}

	pub fn telefono(&self)->String {
		self.telefono.to_string()
	}

    pub fn email(&self) -> String{
		self.email.to_string()
	}

    pub fn tipo(&self) -> TipoPqrs{
		self.tipo.clone()
	}

	pub fn estado(&self) -> EstadoPqrs{
		self.estado.clone()
	}

	pub fn asunto(&self) -> String{
		self.asunto.to_string()
	}

	pub fn mensaje(&self) -> String{
		self.mensaje.to_string()
	}

	pub fn usuario_creador(&self) -> String{
		self.usuario_creador.to_string()
	}

}
