use serde_derive::{Deserialize, Serialize};

#[derive(Deserialize, Serialize, Clone, Debug, PartialEq)]
pub enum Pantallas{
    AdministracionUsuarios,
    CrearEditarUsuario,
    EliminarUsuario,
    ActivarDesactivarUsuario,
    RolesObjetos,
    AsignarRol,
    AsignarObjeto,
    CrearEditarRol,
    EliminarRol,
    Consultas,
    EntradaCana,
    InformeProduccion,
    LiquidacionCana,
    Cronologico,
    AsistenciaTecnica,
    ActualizacionDatos,
    AdministracionDocumentos,
    AdministracionOrdenes,
    AdministracionAsistenciaTecnica,
    CerrarSesion,
    AdminActualizarDatos,
}


#[derive(Deserialize, Serialize, Clone, Debug, PartialEq, PartialOrd, Eq, Ord)]
pub enum ObjetosSeguridad{
    EC001,
    IP001,
    LC001,
    CO001,
    CR001,
    AT001,
    AO001,
    AO002,
    AD001,
    //AD002,
    AU000,
    AU001,
    AU002,
    AU003,
    AU004,
    AU005,
    AU006,
   // AU007,
    RO001,
    RO002,
    RO003,
    RO004,
    RO005,
    RO006,
    RO007,
    CS001,
    AA001,
	AB001,
	AR002,
	AR003,
	AR004,
	AR005,
	AC001,
	AC002,
	AC003,
	AC004,
	AC005,
	AE001,
	AE002,
	AE003,
	AE004,
	AE005,
	AE006,
	AE007,
    ZZ999,
}

pub const RELACION_OBJETOS_PANTALLAS  : [(Pantallas, ObjetosSeguridad); 61] = 
    [
	(Pantallas::EntradaCana,ObjetosSeguridad::EC001),
	(Pantallas::InformeProduccion,ObjetosSeguridad::IP001),
	(Pantallas::LiquidacionCana,ObjetosSeguridad::LC001),
	(Pantallas::Consultas,ObjetosSeguridad::CO001),
	(Pantallas::Cronologico,ObjetosSeguridad::CR001),
	(Pantallas::AsistenciaTecnica,ObjetosSeguridad::AT001),
	(Pantallas::ActualizacionDatos,ObjetosSeguridad::AO001),
	(Pantallas::AdministracionDocumentos,ObjetosSeguridad::AD001),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU000),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU001),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU003),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU004),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU005),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU006),
	//(Pantallas::AdministracionUsuarios,ObjetosSeguridad::AU007),
	(Pantallas::AdminActualizarDatos,ObjetosSeguridad::AO002),
	(Pantallas::RolesObjetos,ObjetosSeguridad::AU002),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO001),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO002),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO003),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO004),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO005),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO006),
	(Pantallas::RolesObjetos,ObjetosSeguridad::RO007),
	(Pantallas::CerrarSesion,ObjetosSeguridad::CS001),
	(Pantallas::ActualizacionDatos,ObjetosSeguridad::AA001),
	(Pantallas::AdministracionAsistenciaTecnica, ObjetosSeguridad::AB001),
	(Pantallas::AdministracionOrdenes, ObjetosSeguridad::AR002),
	(Pantallas::AdministracionOrdenes, ObjetosSeguridad::AR003),
	(Pantallas::AdministracionOrdenes, ObjetosSeguridad::AR004),
	(Pantallas::AdministracionOrdenes, ObjetosSeguridad::AR005),
	(Pantallas::AdministracionUsuarios,ObjetosSeguridad::ZZ999),
	(Pantallas::CrearEditarUsuario,ObjetosSeguridad::ZZ999),
	(Pantallas::EliminarUsuario,ObjetosSeguridad::ZZ999),
	(Pantallas::ActivarDesactivarUsuario,ObjetosSeguridad::ZZ999),
	(Pantallas::RolesObjetos,ObjetosSeguridad::ZZ999),
	(Pantallas::AsignarRol,ObjetosSeguridad::ZZ999),
	(Pantallas::AsignarObjeto,ObjetosSeguridad::ZZ999),
	(Pantallas::CrearEditarRol,ObjetosSeguridad::ZZ999),
	(Pantallas::EliminarRol,ObjetosSeguridad::ZZ999),
	(Pantallas::Consultas,ObjetosSeguridad::ZZ999),
	(Pantallas::EntradaCana,ObjetosSeguridad::ZZ999),
	(Pantallas::InformeProduccion,ObjetosSeguridad::ZZ999),
	(Pantallas::LiquidacionCana,ObjetosSeguridad::ZZ999),
	(Pantallas::Cronologico,ObjetosSeguridad::ZZ999),
	(Pantallas::AsistenciaTecnica,ObjetosSeguridad::ZZ999),
	(Pantallas::ActualizacionDatos,ObjetosSeguridad::ZZ999),
	(Pantallas::AdministracionDocumentos,ObjetosSeguridad::ZZ999),
	(Pantallas::CerrarSesion,ObjetosSeguridad::ZZ999),
	(Pantallas::Cronologico,ObjetosSeguridad::AC001),
	(Pantallas::Cronologico,ObjetosSeguridad::AC001),
	(Pantallas::Cronologico,ObjetosSeguridad::AC002),
	(Pantallas::Cronologico,ObjetosSeguridad::AC003),
	(Pantallas::Cronologico,ObjetosSeguridad::AC004),
	(Pantallas::Cronologico,ObjetosSeguridad::AC005),
	(Pantallas::Cronologico,ObjetosSeguridad::AE001),
	(Pantallas::Consultas,ObjetosSeguridad::AE002),
	(Pantallas::Consultas,ObjetosSeguridad::AE003),
	(Pantallas::Consultas,ObjetosSeguridad::AE004),
	(Pantallas::Consultas,ObjetosSeguridad::AE005),
	(Pantallas::Consultas,ObjetosSeguridad::AE006),
	(Pantallas::Consultas,ObjetosSeguridad::AE007),
    ];

impl ObjetosSeguridad{
    pub fn descripcion(&self) -> (ObjetosSeguridad, &str) {
	match self{
	    Self::EC001 => (Self::EC001,"Menú-Entrada de Caña"),
	    Self::IP001 => (Self::IP001,"Menú-Histórico de Produccción"),
	    Self::LC001 => (Self::LC001,"Menú-Liquidación de Caña"),
	    Self::CO001 => (Self::CO001,"Menú-Extractos"),
	    Self::CR001 => (Self::CR001,"Menú-Prontuario de Suertes"),
	    Self::AT001 => (Self::AT001,"Menú-Planos"),
	    Self::AO001 => (Self::AO001,"Menú-Actualización de Datos"),
	    Self::AO002 => (Self::AO002,"Menú-Publicaciones"),
	    Self::AD001 => (Self::AD001,"Menú-PQRs"),
	    //Self::AD002 => (Self::AD002,"Menú-Administración de Documentos-Procesar"),
	    Self::AU000 => (Self::AU000,"Menú-Configuración"),
	    Self::AU001 => (Self::AU001,"Menú-Configuración-Gestión de Usuarios"),
	    Self::AU002 => (Self::AU002,"Menú-Configuración-Roles y Objetos de Seguridad"),
	    Self::AU003 => (Self::AU003,"Menú-Configuración-Gestión de Usuarios-Crear Usuario"),
	    Self::AU004 => (Self::AU004,"Menú-Configuración-Gestión de Usuarios-Editar Usuario"),
	    Self::AU005 => (Self::AU005,"Menú-Configuración-Gestión de Usuarios-Eliminar Usuario"),
	    Self::AU006 => (Self::AU006,"Menú-Configuración-Gestión de Usuarios-Activar Usuario"),
	   // Self::AU007 => (Self::AU007,"Menú-Configuración-Gestión de Usuarios-Desactivar Usuario"),//quitar
	    Self::RO001 => (Self::RO001,"Menú-Configuración-Roles y Objetos de Seguridad-Crear Rol"),
	    Self::RO002 => (Self::RO002,"Menú-Configuración-Roles y Objetos de Seguridad-Editar Rol"),
	    Self::RO003 => (Self::RO003,"Menú-Configuración-Roles y Objetos de Seguridad-Eliminar Rol"),
	    Self::RO004 => (Self::RO004,"Menú-Configuración-Roles y Objetos de Seguridad-Asignar Rol"),
	    Self::RO005 => (Self::RO005,"Menú-Configuración-Roles y Objetos de Seguridad-Quitar Rol"),
	    Self::RO006 => (Self::RO006,"Menú-Configuración-Roles y Objetos de Seguridad-Asignar Objetos"),
	    Self::RO007 => (Self::RO007,"Menú-Configuración-Roles y Objetos de Seguridad-Quitar Objetos"),
	    Self::CS001 => (Self::CS001,"Menú-Cerrar Sesión"),
	    Self::AA001 => (Self::AA001,"Menú-Configuración-Administración Actualización de Datos"),
		Self::AB001 => (Self::AB001,"Menú-Configuración-Administración de Documentos"),
		Self::AR002 => (Self::AR002,"Menú-Configuración-Administración de Órdenes"),
		Self::AR003 => (Self::AR003,"Menú-Configuración-Administración de Órdenes-Editar"),
		Self::AR004 => (Self::AR004,"Menú-Configuración-Administración de Órdenes-Eliminar"),
		Self::AR005 => (Self::AR005,"Menú-Configuración-Administración de Órdenes-Distribuir"),

		Self::AC001 => (Self::AC001,"Menú-Configuración-Administración de Publicaciones"),
		Self::AC002 => (Self::AC002,"Menú-Configuración-Administración de Publicaciones-Crear"),
		Self::AC003 => (Self::AC003,"Menú-Configuración-Administración de Publicaciones-Editar"),
		Self::AC004 => (Self::AC004,"Menú-Configuración-Administración de Publicaciones-Eliminar"),
		Self::AC005 => (Self::AC005,"Menú-Configuración-Administración de Publicaciones-Biblioteca de Archivos"),
		Self::AE001 => (Self::AE001,"Menú-Configuración-Administración de PQRS"),
		Self::AE002 => (Self::AE002,"Menú-Configuración-Administración de PQRS-Crear"),
		Self::AE003 => (Self::AE003,"Menú-Configuración-Administración de PQRS-Editar"),
		Self::AE004 => (Self::AE004,"Menú-Configuración-Administración de PQRS-Eliminar"),
		Self::AE005 => (Self::AE005,"Menú-Configuración-Administración de PQRS-Ver Detalle"),
		Self::AE006 => (Self::AE006,"Menú-Configuración-Administración de PQRS-Cambiar Estado"),
		Self::AE007 => (Self::AE007,"Menú-Configuración-Administración de PQRS-Ver Todas Las PQRS"),
	    Self::ZZ999 => (Self::ZZ999,"Super Usuario Administrador"),
	}
    }

    
}
