use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use crate::errors;
use super::usuario::Usuario;
use super::{Storable};
use crate::{audit, store};
use std::default::Default;
use std::hash::{Hash, Hasher};
audit!{LogPolitica}//macro
store!{LogPolitica,id,vec![],vec![]}

#[derive(Deserialize, Serialize,Clone)]
pub struct LogPolitica{
    
    id: String,
    usuario_id : String,
    usuario : String,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,

}


impl LogPolitica{
    pub fn new (usuario: &Usuario) -> Self{
        
        let now = crate::utils::now_microseconds();
        Self{
            id:Default::default(),
            usuario_id : usuario.id(),
            usuario : usuario.nombre_completo(),
            creation_stamp: now,
            created_by: usuario.id(),
            modification_stamp: now,
            modified_by: usuario.id(),
        
        }
    }

    pub fn consulta(db:&std::sync::Arc<sled::Db> ,ini:i64,fin:i64) -> Vec <Self>{

        LogPolitica::scan(db,|row|{
            crate::utils::ientre_rango(row.creation_stamp,ini,fin)
            }
        )

    }
    
    pub fn usuario_id(&self)-> String{
        self.usuario_id.to_string()
    }

    pub fn usuario(&self)-> String{
        self.usuario.to_string()
    }

}