use chrono::prelude::*;
use serde_derive::{Deserialize, Serialize};
use crate::errors;
use super::usuario::Usuario;
use super::{Storable};
use crate::{audit, store};
use std::default::Default;
use std::hash::{Hash, Hasher};
audit!{AsistenciaTecnica}

const llave_busqueda : &str = "BUSDOC";

#[derive(Deserialize, Serialize, Debug, Clone, Hash)]
pub enum CategoriasSoca {
    Encalle,
    Roturacion,
    Resiembra,
    Fertilizacion,
    ControlDeMalezas,
    Aporque,
    RiegoDLevante,
    ControlDePlagasYEnfermedades,
    Agostamiento,
}

#[derive(Deserialize, Serialize, Debug, Clone, Hash)]
pub enum CategoriasPlantilla{
    Adecuacion,
    Renovacion,
    Siembra,
    RiegoGerminacion,
    ControlMalezaPreEmergente,
    Fertilizacion,
    RiegoDeLevante,
    ControlPlagasYEnfermedades,
    Agostamiento,
}

#[derive(Deserialize, Serialize, Debug, Clone, Hash)]
pub enum CategoriaAsistencia{
    Ninguna,
    Plantilla(CategoriasPlantilla),
    Socas(CategoriasSoca),
}

impl Default for CategoriaAsistencia{
    fn default() -> Self{
	Self::Ninguna
    }
}



#[derive(Deserialize, Serialize, Debug, Clone)]
pub struct AsistenciaTecnica{
    categoria: CategoriaAsistencia,
    texto: String,
    creation_stamp: i64,
    created_by: String,
    modification_stamp: i64,
    modified_by: String,
}

impl Default for AsistenciaTecnica {
    fn default () -> Self {
	Self{
	    categoria: Default::default(),
	    texto: Default::default(),
	    creation_stamp: Utc::now().timestamp(),
	    created_by: Default::default(),
	    modification_stamp: Utc::now().timestamp(),
	    modified_by: Default::default(),
	}
    }
}

impl crate::model::Storable for AsistenciaTecnica {

    fn index_list() -> Vec<&'static str>{
	vec![]
    }

    fn keys() -> Vec<&'static str>{
	vec![]
    }

    fn id_prefix() -> String {
	
	stringify!(AsistenciaTecnica).to_string()
    }

    
    fn id(&self) -> String{

	Self::hash_categoria(&self.categoria)
	    
    }

    fn set_id(&mut self, id:&str){

    }

    fn to_raw(&self) -> Vec<u8>{
	rmp_serde::to_vec(self).unwrap()
    }

    fn from_raw(raw_data: Vec<u8>) -> Result<Self, Box< dyn std::error::Error> > {
	Ok( rmp_serde::from_read_ref(&raw_data).map_err(|e| Box::new(errors::StorableError::ReadError( e.to_string() )) )? )
    }

    fn import_tab_stream_reader(db : &sled::Db, s_in: &dyn std::io::Read) -> Result<(), Box<dyn std::error::Error>>{
	Ok(())
    }

    fn export_tab_stream_writer(db : &sled::Db, s_out: &dyn std::io::Write) -> Result<(), Box<dyn std::error::Error>>{
	Ok(())
    }

}


impl AsistenciaTecnica {
    pub fn new() -> Self {
	Default::default()
    }

    pub fn hash_categoria(categoria: &CategoriaAsistencia) -> String {

	let mut s = std::collections::hash_map::DefaultHasher::new();
	
	categoria.hash(&mut s);

	format!("{prefijo}{hash}",prefijo=Self::id_prefix(),hash=s.finish())

    }
    
    pub fn texto(&self) -> String{
	self.texto.to_string()
    }
        
    pub fn set_texto(&mut self, i:String){
	self.texto = i;
    }

    pub fn categoria(&self) -> CategoriaAsistencia {
	self.categoria.clone()
    }

    pub fn set_categoria(&mut self, i:CategoriaAsistencia){
	self.categoria = i;
    }


}
