use serde_derive::{Deserialize, Serialize};

#[derive(Deserialize, Serialize, Debug)]
pub struct ResponseStatus{
    pub code: String,
    pub message: String,
    pub traceback: String    
}

impl warp::reject::Reject for ResponseStatus {}

#[derive(Deserialize, Serialize, Debug)]
pub struct ResponseStructure{
    pub response_status: ResponseStatus,
    pub payload: serde_json::Value,
}

impl warp::reject::Reject for ResponseStructure {}


pub fn ok_response()  -> ResponseStatus {
    ResponseStatus{
	code: "0000".to_string(),
	message: "".to_string(),
	traceback: "".to_string()
    }
}

pub fn convert_err_to_response(e: Box<dyn std::error::Error>) -> ResponseStatus {

    let raw_msg = e.to_string();
    let (code, message) = {
	let mut it = raw_msg.split('|');
	( it.next().unwrap_or("NO_CODE"), it.next().unwrap_or("NO_MESSAGE") )
    };

    ResponseStatus{
	code: code.to_string(),
	message: message.to_string(),
	traceback: "".to_string(),
    }
}

pub fn error_response(error: Box<dyn std::error::Error>) -> Result<warp::reply::Json, warp::Rejection>{
    Err(
	warp::reject::custom(ResponseStructure {
	    response_status : convert_err_to_response(error),
	    payload : serde_json::json!({}),
	})
    )
}

pub fn error_response_map(error: Box<dyn std::error::Error>) -> warp::Rejection{
	warp::reject::custom(ResponseStructure {
	    response_status : convert_err_to_response(error),
	    payload : serde_json::json!({}),
	})
}

pub fn return_ok_reponse_map(payload: impl serde::Serialize) -> warp::reply::Json{
    warp::reply::json(&ResponseStructure {
	response_status : ok_response(),
	payload : serde_json::json!(payload),
    })
}

pub fn return_ok_reponse(payload: impl serde::Serialize) -> Result<warp::reply::Json, warp::Rejection>{
    Ok(
	warp::reply::json(&ResponseStructure {
	    response_status : ok_response(),
	    payload : serde_json::json!(payload),
	})
    )
}
    
