use serde_derive::{Deserialize, Serialize};
use crate::interfaces;
use crate::model::Storable;
use crate::model::trazabilidad_plataforma::{TrazabilidadPlataforma,ObjetoModificado};
use crate::model::log_politica::{LogPolitica};
use crate::model::{
    usuario::Usuario,
    usuario::id_rol,
    rol::Rol,
    sesion::Sesion,
    objetos_seguridad::{ObjetosSeguridad, RELACION_OBJETOS_PANTALLAS, Pantallas},
};
use warp::{http::header::HeaderValue};
use crate::errors;
use crate::tmpdownloadpdffmt;
use crate::model::Auditable;


#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct CrearUsuario{
    usuario: String,
    nombre_completo: String,
    clave_acceso: String,
    telefono1: String,
    telefono2: String,
    telefono3: String,
    email: String,
    email_alternativo: String,
    nits: Vec<String>,
    roles: Vec<id_rol>,
}



pub async fn crear_usuario(datos_usuario:CrearUsuario, sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

	let listado_usuarios = Usuario::scan(&db,|x| true);
	let mut count:i64 = 0; 

	for line in listado_usuarios.into_iter(){
		if line.email() == datos_usuario.email {

			if !line.bloqueo() &&  line.eliminado() == None{
				count = count+1;
			} 
		}
	}

	if count >= 1{
		dbg!( "ingreso" );
	    return interfaces::error_response(Box::new(errors::AuthenticationError::DuplicacionEmail));
	  // interfaces::error_response(Box::new(errors::AuthenticationError::DuplicacionEmail))
	}
	else{
		let mut nuevo_usuario = Usuario::crear(
		&db,
		&datos_usuario.usuario,
		&datos_usuario.clave_acceso,
		&datos_usuario.nombre_completo,
		&datos_usuario.telefono1,
		&datos_usuario.telefono2,
		&datos_usuario.telefono3,
		&datos_usuario.email,
		&datos_usuario.email_alternativo,
		&datos_usuario.nits,
		&datos_usuario.roles,
		);

		match nuevo_usuario{
		Ok(mut nuevo_usuario) =>{
			match nuevo_usuario.store(&db, &sesion) {
			Ok(()) => {
				interfaces::return_ok_reponse( &serde_json::json!( { "id": nuevo_usuario.id() } ) )
			},
			Err(_why) => interfaces::error_response( _why ),
			}
		},
		Err(_why) => interfaces::error_response( _why ),
		}
    
	}
    
}
 #[derive(Deserialize)]
 pub struct ActualizarUsuario  {

	usuario_id: String,
	usuario: String,
	nombre_completo: String,
	telefono1: String,
	telefono2: String,
	email: String,
	nits: Vec<String>,
	bloqueo: bool,

 }

pub async fn actualizar_usuario(usuario: ActualizarUsuario, sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

	let listado_usuarios = Usuario::scan(&db,|x| true);
	let mut count:i64 = 0; 

	for line in listado_usuarios.into_iter(){
		dbg!( &usuario.email );
		dbg!( &line.email() );
		dbg!( &line.usuario() );
		dbg!( &usuario.usuario );
		dbg!( &line.bloqueo() );
		if line.email() == usuario.email && line.usuario() != usuario.usuario{

		    if !line.bloqueo() &&  line.eliminado() == None{
				count = count+1;
			} 
		}
	}
	dbg!( &count );
	if count >= 1{
		dbg!( "ingreso" );
	    return interfaces::error_response(Box::new(errors::AuthenticationError::DuplicacionEmail));
	   //interfaces::error_response(Box::new(errors::AuthenticationError::DuplicacionEmail))
	}
	else{
		match Usuario::load(&db,&usuario.usuario_id){
		Ok(resultado) => {
			if let Some(mut usuario_encontrado) = resultado{
			
				if usuario.bloqueo != usuario_encontrado.bloqueo(){
					let om = ObjetoModificado::Usuario{id:usuario.usuario_id.to_string()};
					let mut estado_antiguo;
					let mut estado_nuevo;
					if usuario_encontrado.bloqueo() {
						estado_antiguo = "Bloqueado".to_string();
					}else{
						estado_antiguo = "Activo".to_string();
					}

					if usuario.bloqueo {
						estado_nuevo =  "Bloqueado".to_string();
					}else{
						estado_nuevo = "Activo".to_string();
					}

					let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,&sesion.usuario().nombre_completo().to_string(),"Editar Usuario",om,"Estado usuario",&estado_antiguo,&estado_nuevo);
					tp.store(&db,&sesion).map_err(|_why|
						{
							interfaces::error_response_map( _why )
						})?;
					
					
				}

				if usuario.nombre_completo != usuario_encontrado.nombre_completo() {
					let om = ObjetoModificado::Usuario{id:usuario.usuario_id.to_string()};
					let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,&sesion.usuario().nombre_completo().to_string(),"Editar Usuario",om,"Nombre Completo",&usuario_encontrado.nombre_completo(),&usuario.nombre_completo);
					tp.store(&db,&sesion).map_err(|_why|
						{
							interfaces::error_response_map( _why )
						})?;
					
				}
				if usuario.email != usuario_encontrado.email() {
					let om = ObjetoModificado::Usuario{id:usuario.usuario_id.to_string()};
					let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,&sesion.usuario().nombre_completo().to_string(),"Editar Usuario",om,"Email",&usuario_encontrado.email(),&usuario.email);
					tp.store(&db,&sesion).map_err(|_why|
						{
							interfaces::error_response_map( _why )
						})?;
					
				}

				if usuario.telefono1 != usuario_encontrado.telefono1() {
					let om = ObjetoModificado::Usuario{id:usuario.usuario_id.to_string()};
					let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,&sesion.usuario().nombre_completo().to_string(),"Editar Usuario",om,"Número telefónico",&usuario_encontrado.telefono1(),&usuario.telefono1);
					tp.store(&db,&sesion).map_err(|_why|
						{
							interfaces::error_response_map( _why )
						})?;
					
				}

				if usuario.telefono2 != usuario_encontrado.telefono2() {
					let om = ObjetoModificado::Usuario{id:usuario.usuario_id.to_string()};
					let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,&sesion.usuario().nombre_completo().to_string(),"Editar Usuario",om,"Número telefónico",&usuario_encontrado.telefono2(),&usuario.telefono2);
					tp.store(&db,&sesion).map_err(|_why|
						{
							interfaces::error_response_map( _why )
						})?;
					
				}

				let a=usuario.nits.iter().all(|x|{usuario_encontrado.nits().iter().any(|y|{x==y})});
				let b=usuario_encontrado.nits().iter().all(|x|{usuario.nits.iter().any(|y|{x==y})});
				if !a || !b {
					let om = ObjetoModificado::Usuario{id:usuario.usuario_id.to_string()};
					let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,&sesion.usuario().nombre_completo().to_string(),"Editar Usuario",om,"Nit",&usuario_encontrado.nits().join(","),&usuario.nits.join(","));
					tp.store(&db,&sesion).map_err(|_why|
						{
							interfaces::error_response_map( _why )
						})?;
				}


				usuario_encontrado.set_usuario(&usuario.usuario);
				usuario_encontrado.set_nombre_completo(&usuario.nombre_completo);
				usuario_encontrado.set_telefono1(&usuario.telefono1);
				usuario_encontrado.set_telefono2(&usuario.telefono2);
				usuario_encontrado.set_email(&usuario.email);
				usuario_encontrado.set_nits(&usuario.nits);
				usuario_encontrado.set_bloqueo(usuario.bloqueo);
				//usuario_encontrado.clear_aceptacion_politica_admin_datos();
			
				match usuario_encontrado.store(&db, &sesion) {
					Ok(()) =>{

						
						// let a=usuario.roles.iter().all(|x|{usuario_encontrado.roles().iter().any(|y|{x==y})});
						// let b=usuario_encontrado.roles().iter().all(|x|{usuario.roles.iter().any(|y|{x==y})});
						// if !a || !b {
							
						// 	let rol_modificado:Vec<String> = usuario.roles().iter().filter_map(|x|{
						// 		if let Ok(val) = Rol::load(&db,x){
						// 			if let Some(rol)=val {
						// 				Some(rol.nombre())
						// 			}else{
						// 				None
						// 			}
						// 		}else{
						// 			None
						// 		}
						// 	}).collect();

						// 	let rol_viejo:Vec<String> = usuario_encontrado.roles().iter().filter_map(|x|{
						// 		if let Ok(val) = Rol::load(&db,x){
						// 			if let Some(rol)=val {
						// 				Some(rol.nombre())
						// 			}else{
						// 				None
						// 			}
						// 		}else{
						// 			None
						// 		}
						// 	}).collect();

						// 	let om = ObjetoModificado::Usuario{id:usuario.id};
						// 	let mut tp = TrazabilidadPlataforma::new(&usuario_encontrado,om,"Roles",&rol_modificado.join(","),&rol_viejo.join(","));
						// 	tp.store(&db,&sesion).map_err(|_why|
						// 		{
						// 			interfaces::error_response_map( _why )
						// 		})?;
						// }
						interfaces::return_ok_reponse( &serde_json::json!( { "id": usuario_encontrado.id() } ) )
					},
					Err(_why) => interfaces::error_response( _why ),
				}
			} else{
			interfaces::error_response(Box::new(errors::StorableError::NotFound(usuario.usuario_id)))
			}
		},
		Err(why) => interfaces::error_response(why),
		}
	}


    
}

pub async fn cerrar_sesion(authorization_header: HeaderValue, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    if let Ok(session_id) = authorization_header.to_str(){

	match Sesion::load(&db, session_id){
	    Ok(found_session) => {
		
		if let Some(session) = found_session{

		    match session.delete(&db){
			Ok(_) => interfaces::return_ok_reponse(serde_json::json!({})),
			Err(_why) => interfaces::error_response(Box::new(errors::AuthenticationError::LogoffFailed)),
		    }
		    
		} else {
		    
		    interfaces::error_response(Box::new(errors::AuthenticationError::LogoffFailed))
			
		}
		
	    },
	    Err(_why) => interfaces::error_response(Box::new(errors::AuthenticationError::LogoffFailed)),
	    
	}	
	
    }else{

	interfaces::error_response(Box::new(errors::AuthenticationError::LogoffFailed))
    }
    
}

pub async fn cerrar_sesion_todos(authorization_header: HeaderValue, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    if let Ok(to_exclude) = authorization_header.to_str(){

	match Sesion::clear_all_sessions(&db,Some(to_exclude)){
	    Ok(_) => interfaces::return_ok_reponse(serde_json::json!({})),
	    Err(why) => interfaces::error_response(why),
	}
	    
    }else{

	interfaces::error_response(Box::new(errors::AuthenticationError::LogoffFailed))
	
    }

}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct EliminarUsuario{
    pub usuario_id:String,
	pub eliminado:String,
	pub email:String,
}

pub async fn eliminar_usuario(parametros: EliminarUsuario, _sesion: Sesion,db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    let now = crate::utils::now_microseconds();
    match Usuario::load(&db,&parametros.usuario_id){
	Ok(resultado) => {
	    if let Some(mut usuario) = resultado{
		let om = ObjetoModificado::Usuario{id:parametros.usuario_id.to_string()};
		let mut tp = TrazabilidadPlataforma::new(&usuario,&_sesion.usuario().nombre_completo().to_string(),"Eliminar Usuario",om,"Eliminar Usuario",&usuario.nombre_completo().to_string(),&usuario.nombre_completo().to_string());
		tp.store(&db,&_sesion).map_err(|_why|
		{
			interfaces::error_response_map( _why )
		})?;
		usuario.set_eliminado(now);
		usuario.set_email(&parametros.email);
		match usuario.store(&db, &_sesion){
		    Ok(_) => interfaces::return_ok_reponse( &serde_json::json!({ "id" : &usuario.id()  }) ),
		    Err(why) => interfaces::error_response(why),
		}
	    } else{
		interfaces::error_response(Box::new(errors::StorableError::NotFound(parametros.usuario_id)))
	    }
	},
	Err(why) => interfaces::error_response(why),
    }
    
}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct CargarUsuario{
    pub usuario_id:String,
}

pub async fn cargar_usuario(usuario_a_cargar: CargarUsuario, sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    match Usuario::load(&db,&usuario_a_cargar.usuario_id){
	Ok(resultado) => {
	    if let Some(mut usuario) = resultado{
		usuario.establecer_clave_vacia();
		interfaces::return_ok_reponse( serde_json::json!(&usuario) )
	    } else{
		interfaces::error_response(Box::new(errors::StorableError::NotFound(usuario_a_cargar.usuario_id)))
	    }
	},
	Err(why) => interfaces::error_response(why),
    }
    
}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct ListarUsuario{
    pub filtro: String,
}

pub async fn listar_usuarios(filtros: ListarUsuario, _sesion: Sesion,db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    
    let result : Vec<Usuario> = Usuario::scan(&db, |x| {

	let user_roles_found : bool = x.roles().iter().map(|i| Rol::load(&db,&i).unwrap_or(None).unwrap_or(Rol::new("","")) ).any(|x| x.nombre().to_lowercase() == filtros.filtro.to_lowercase());
	
	x.usuario().to_lowercase().contains(&filtros.filtro.to_lowercase()) || x.nombre_completo().to_lowercase().contains(&filtros.filtro.to_lowercase()) || x.telefono1().to_lowercase().contains(&filtros.filtro.to_lowercase()) || x.email().to_lowercase().contains( &filtros.filtro.to_lowercase() ) || user_roles_found || x.telefono2().to_lowercase().contains(&filtros.filtro.to_lowercase()) 
	} )
	.into_iter()
	.map(|mut x| { x.establecer_clave_vacia(); x })
	.collect();

    interfaces::return_ok_reponse( serde_json::json!(&result) )

}


#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct ListarRolesAsignadosUsuario{
    usuario_id: String,
}

pub async fn listar_roles_asignados_usuario(parametros: ListarRolesAsignadosUsuario, _sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {


    match Usuario::load(&db, &parametros.usuario_id){
	Ok(resultado) => match resultado {
	    Some(usuario) =>{
		let roles_asignados = usuario
		    .roles()
		    .iter()
		    .filter_map(|rol_id|{
			Rol::load(&db, rol_id).unwrap_or( None )
		    })
		    .collect::<Vec<Rol>>();

		interfaces::return_ok_reponse(&roles_asignados)
	    },
	    None => interfaces::error_response(Box::new(errors::StorableError::NotFound(parametros.usuario_id)))
	},
	Err(why) => interfaces::error_response(why),
    }
    
}


#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct ListarRolesNoAsignadosUsuario{
    usuario_id: String,
}

pub async fn listar_roles_noasignados_usuario(parametros: ListarRolesNoAsignadosUsuario, _sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    match Usuario::load(&db, &parametros.usuario_id){
	Ok(resultado) => match resultado {
	    Some(usuario) =>{
		let roles_asignados = usuario
		    .roles()
		    .iter()
		    .filter_map(|rol_id|{
			Rol::load(&db, rol_id).unwrap_or( None )
		    })
		    .collect::<Vec<Rol>>();

		let roles_no_asignados = Rol::scan(&db,|_x| true)
		    .iter()
		    .filter(|x| roles_asignados.iter().find(|y| y == x) == None)
		    .map(|x| x.clone())
		    .collect::<Vec<Rol>>();
		
		interfaces::return_ok_reponse(&roles_no_asignados)
	    },
	    None => interfaces::error_response(Box::new(errors::StorableError::NotFound(parametros.usuario_id)))
	},
	Err(why) => interfaces::error_response(why),
    }
    
}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct AsignarRolUsuario{
    usuario_id: String,
    rol_ids: Vec<String>,
	rol_nombre: Vec<String>,
}

pub async fn asignar_rol_usuario(mut parametros: AsignarRolUsuario, _sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    match Usuario::load(&db,&parametros.usuario_id){
	Ok(resultado) => {
	    if let Some(mut usuario) = resultado{
		let om = ObjetoModificado::Usuario{id:parametros.usuario_id};
		let mut tp = TrazabilidadPlataforma::new(&usuario,&_sesion.usuario().nombre_completo().to_string(),"Asignar Rol a Usuario",om,"Rol","Roles",&parametros.rol_nombre.join(","));
		tp.store(&db,&_sesion).map_err(|_why|
			{
				interfaces::error_response_map( _why )
			})?;
		usuario.agregar_roles(&mut parametros.rol_ids);
		match usuario.store(&db, &_sesion){
		    Ok(_) => interfaces::return_ok_reponse( serde_json::json!({}) ),
		    Err(why) => interfaces::error_response(why),
		}
		
	    } else{
		interfaces::error_response(Box::new(errors::StorableError::NotFound(parametros.usuario_id)))
	    }
	},
	Err(why) => interfaces::error_response(why),
    }
}


#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct RemoverRolUsuario{
    usuario_id: String,
    rol_ids: Vec<String>,
	rol_nombre: Vec<String>,
}

pub async fn remover_rol_usuario(parametros: RemoverRolUsuario, _sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    match Usuario::load(&db,&parametros.usuario_id){
	Ok(resultado) => {
	    if let Some(mut usuario) = resultado{
			let om = ObjetoModificado::Usuario{id:parametros.usuario_id};
			let mut tp = TrazabilidadPlataforma::new(&usuario,&_sesion.usuario().nombre_completo().to_string(),"Remover Rol a Usuario",om,"Rol","Roles",&parametros.rol_nombre.join(","));
			tp.store(&db,&_sesion).map_err(|_why|
				{
					interfaces::error_response_map( _why )
				})?;
			usuario.remover_roles(&parametros.rol_ids);
			match usuario.store(&db, &_sesion){
				Ok(_) => interfaces::return_ok_reponse( serde_json::json!({}) ),
				Err(why) => interfaces::error_response(why),
			}
		
	    } else{
		interfaces::error_response(Box::new(errors::StorableError::NotFound(parametros.usuario_id)))
	    }
	},
	Err(why) => interfaces::error_response(why),
    }
}


pub async fn expresion_regular_complejidad_clave(_sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    interfaces::return_ok_reponse( serde_json::json!({"expresion_regular":"/65465465/"})  )
}

pub async fn validar_sesion(_sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    interfaces::return_ok_reponse( serde_json::json!({}) )
}



pub async fn usuario_actual(_sesion: Sesion,db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    interfaces::return_ok_reponse( serde_json::json!({ "usuario" : &_sesion.usuario().usuario(), "id_usuario" : &_sesion.usuario().usuario_id() }) )
}

#[derive(Deserialize, Serialize, Clone, Debug, PartialEq)]
pub struct ValueActivo{
    usuario_id: String,
}

pub async fn usuario_activo_or_eliminado(_sesion: Sesion,db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    


	match Usuario::load(&db,&_sesion.usuario().id()){
		Ok(resultado) => {
			if let Some(mut usuario_encontrado) = resultado{
					dbg!( &usuario_encontrado );
				if  usuario_encontrado.bloqueo(){
					return interfaces::error_response( Box::new(errors::AuthenticationError::UsuarioInactivo{user: usuario_encontrado.usuario().to_string() } ) );
				}
				else if( usuario_encontrado.eliminado() != None ){
					return interfaces::error_response( Box::new(errors::AuthenticationError::UsuarioEliminado{user: usuario_encontrado.usuario().to_string() } ) );
				}
				else{
					return interfaces::return_ok_reponse( serde_json::json!({}) );
				}
			}
			else{
				interfaces::error_response(Box::new(errors::StorableError::NotFound(_sesion.usuario().id())))
			}
		},
		Err(why) => interfaces::error_response( why ),	
	}
	
	//interfaces::return_ok_reponse( serde_json::json!({}) )
}

#[derive(Deserialize, Serialize, Clone, Debug, PartialEq)]
pub struct ObjetosSeguridadMenu{
    pantalla: Pantallas,
}

pub async fn objetos_seguridad_menu(parametros: ObjetosSeguridadMenu, _sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    match Usuario::load(&db,&_sesion.usuario().id()){
	Ok(resultado) => {
	    if let Some(mut usuario) = resultado {
		let listado_objetos_usuario : Vec<ObjetosSeguridad> = usuario.roles()
		    .iter()
		    .filter_map(|x| Rol::load(&db, &x).ok())
		    .flat_map(|x| x.unwrap_or(Rol::new("","")).objetos().clone())
		    .collect();

		let objetos_de_pantalla : Vec<ObjetosSeguridad> = RELACION_OBJETOS_PANTALLAS
		    .iter()
		    .filter(|x| parametros.pantalla == x.0)
		    .filter(|x| listado_objetos_usuario.iter().find(|y| x.1 == **y) != None )
		    .map(|x| x.1.clone() )
		    .collect();

		interfaces::return_ok_reponse( &objetos_de_pantalla )
		
	    }else {
		interfaces::error_response(Box::new(errors::StorableError::NotFound(_sesion.usuario().id())))
	    }
	},
	Err(why) => interfaces::error_response(why),
    }    

}

pub async fn objetos_seguridad(_sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    match Usuario::load(&db,&_sesion.usuario().id()){
	Ok(resultado) => {
	    if let Some(mut usuario) = resultado {
		let listado_objetos_usuario : Vec<ObjetosSeguridad> = usuario.roles()
		    .iter()
		    .filter_map(|x| Rol::load(&db, &x).ok())
		    .flat_map(|x| x.unwrap_or(Rol::new("","")).objetos().clone())
		    .collect();

		interfaces::return_ok_reponse( &listado_objetos_usuario )
		
	    }else {
		interfaces::error_response(Box::new(errors::StorableError::NotFound(_sesion.usuario().id())))
	    }
	},
	Err(why) => interfaces::error_response(why),
    }    

}
#[derive(Deserialize)]
pub struct ReporteTrazabilidadAcciones{
	ini: i64,
	fin : i64
}

#[derive(Serialize)]
pub struct RespuestaReporteTrazabilidadAcciones{
	ruta:String
}

pub async fn reporte_trazabilidad_acciones_usuarios(parametros: ReporteTrazabilidadAcciones,_sesion: Sesion,db: std::sync::Arc<sled::Db>)-> Result<impl warp::Reply, warp::Rejection>{
    
	#[derive(Serialize)]
	struct EstructuraReporte{
		
		modificado_por:String,
		usuario : String,
		objeto_modificado : String,
		actividad : String,
		campo:String,
		valor_antes:String,
		valor_despues:String,
		creation_stamp: String,
	}

	let resultado = TrazabilidadPlataforma::consulta(&db,parametros.ini,parametros.fin).iter().map(|x|{
        
		let usuario = Usuario::load(&db,&x.usuario_id())?.ok_or(
			
			Box::new (errors::GeneracionReportes::NoSepuedeCargarusuario{usuario:x.usuario_id().to_string(),motivo:"No se puede cargar el usuario".to_string()})
		)?;
		Ok( 
			EstructuraReporte{
			    modificado_por:x.modificado_por(),
				usuario : usuario.nombre_completo().to_string(),
				objeto_modificado :x.objeto_modificado().into(),
				actividad:x.accion(),
				campo:x.campo_modificado(),
				valor_antes:x.valor_antes(),
				valor_despues:x.valor_despues(),
				creation_stamp:crate::utils::utc_timestamp_to_string(x.creation_stamp())
			}
		)
	}).collect::<Result<Vec<EstructuraReporte>,Box<dyn std::error::Error>>>().map_err(|e|{
		interfaces::error_response_map(e)
	})?;

	use crate::{tmptxtfmt};
	use std::fs::File;
    
    let file_path = tmptxtfmt!(crate::utils::generate_id());
    let write_path = std::path::Path::new(&file_path);
	let mut f = File::create(&write_path).map_err(|e|{

		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepudeCrearTemporalReporte{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))

	})?;
    let mut wtr = csv::Writer::from_writer(f);

	let encabezado = EstructuraReporte{
		
		modificado_por:"Modificado Por".to_string(),
		usuario :"Usuario".to_string(),
		objeto_modificado :"Objeto Modificado".to_string(),
		actividad:"Actividad".to_string(),
		campo:"Campo".to_string(),
		valor_antes:"Valor Anterior".to_string(),
		valor_despues:"Valor Modificado".to_string(),
		creation_stamp:"Fecha de Registro".to_string()
	};

	wtr.serialize(encabezado).map_err(|e|{
	interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeEscribirLinea{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))
	})?;
	
	for line in resultado.into_iter(){

		wtr.serialize(line).map_err(|e|{
			interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeEscribirLinea{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))
		})?;
	}

	wtr.flush().map_err(|e|{
		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeCerrarArchivo{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))
	})?;
    
    let archivo=write_path.file_name().ok_or(
		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeObtenerNombreArchivo{nombre_archivo:file_path.to_string(),motivo:"No se puede obtener el nombre del archivo".to_string()}))
	)?.to_str().ok_or(
		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeObtenerRutaArchivo{nombre_archivo:file_path.to_string(),motivo:"No se puede obtener al ruta del el archivo ".to_string()}))
	)?;
	let res = RespuestaReporteTrazabilidadAcciones{
		ruta:tmpdownloadpdffmt!(archivo)
	};

	interfaces::return_ok_reponse(&res)

}

#[derive(Deserialize)]
pub struct ReporteLogPolitica{
	ini: i64,
	fin : i64
}

#[derive(Serialize)]
pub struct RespuestaLogPolitica{
	ruta:String
}

pub async fn reporte_politica(parametros: ReporteLogPolitica,_sesion: Sesion,db: std::sync::Arc<sled::Db>)-> Result<impl warp::Reply, warp::Rejection>{
    
	#[derive(Serialize)]
	struct EstructuraReportePolitica{
		
		usuario : String,
		fecha: String,
	}

	let resultado = LogPolitica::consulta(&db,parametros.ini,parametros.fin).iter().map(|x|{
        
		let usuario_politica = Usuario::load(&db,&x.usuario_id())?.ok_or(
			
			Box::new (errors::GeneracionReportes::NoSepuedeCargarusuario{usuario:x.usuario_id().to_string(),motivo:"No se puede cargar el usuario".to_string()})
		)?;
		Ok( 
			EstructuraReportePolitica{
			
				usuario : usuario_politica.nombre_completo().to_string(),
				fecha:crate::utils::utc_timestamp_to_string(x.creation_stamp())
			}
		)

	}).collect::<Result<Vec<EstructuraReportePolitica>,Box<dyn std::error::Error>>>().map_err(|e|{
		interfaces::error_response_map(e)
	})?;

	use crate::{tmptxtfmt};
	use std::fs::File;
    
    let file_path = tmptxtfmt!(crate::utils::generate_id());
    let write_path = std::path::Path::new(&file_path);
	let mut f = File::create(&write_path).map_err(|e|{

		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepudeCrearTemporalReporte{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))

	})?;
    let mut wtr = csv::Writer::from_writer(f);

	let encabezado = EstructuraReportePolitica{
			
		usuario :"Usuario".to_string(),
		fecha:"Fecha".to_string()
	};

	wtr.serialize(encabezado).map_err(|e|{
	interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeEscribirLinea{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))
	})?;
	
	for line in resultado.into_iter(){

		wtr.serialize(line).map_err(|e|{
			interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeEscribirLinea{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))
		})?;
	}

	wtr.flush().map_err(|e|{
		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeCerrarArchivo{nombre_archivo:file_path.to_string(),motivo:e.to_string()}))
	})?;
    
    let archivo=write_path.file_name().ok_or(
		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeObtenerNombreArchivo{nombre_archivo:file_path.to_string(),motivo:"No se puede obtener el nombre del archivo".to_string()}))
	)?.to_str().ok_or(
		interfaces::error_response_map(Box::new (errors::GeneracionReportes::NoSepuedeObtenerRutaArchivo{nombre_archivo:file_path.to_string(),motivo:"No se puede obtener al ruta del el archivo ".to_string()}))
	)?;
	let res = RespuestaLogPolitica{
		ruta:tmpdownloadpdffmt!(archivo)
	};

	interfaces::return_ok_reponse(&res)

}

