use crate::tls_certificates;


pub async fn order_cert(tls_cert_name: std::sync::Arc<String>, tls_cert_account: std::sync::Arc<String>) -> Result<impl warp::Reply, warp::Rejection> {

    let handle : std::thread::JoinHandle<std::result::Result<std::string::String, std::string::String>> = std::thread::spawn(move ||{
	
	match tls_certificates::request_cert(&tls_cert_account, &tls_cert_name){
	    Ok(_) => {
		Ok(format!("Certificate generation in process...."))
	    },
	    Err(why) => {
		Ok(format!("Error ordering certificate. Reason:{}",why))
	    }
	}

    });

    Ok("Certificate generation in process")

}
