use std::default::Default;
use serde::{Serialize, Deserialize};
use crate::{errors, interfaces};

const llave : &str = "politica_datos_personales";

#[derive(Serialize, Deserialize)]
pub struct PoliticaDatosPersonales{
    pub texto:String
}

impl std::default::Default for PoliticaDatosPersonales{
    fn default() -> Self{
	Self{
	    texto: Default::default(),
	}
    }
}

pub async fn recuperar_texto(db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    let mut politica : PoliticaDatosPersonales = Default::default();
    
    if let Some(bytes) = db.get(llave).map_err(|why| interfaces::error_response_map(Box::new(errors::StorableError::ReadError(why.to_string())) ))? {
	politica.texto = std::str::from_utf8(&bytes)
	    .map_err(|why| interfaces::error_response_map(Box::new(errors::StorableError::ReadError(why.to_string())) ))?.to_string();
    }else{
	politica.texto = "".to_string();
    }
    
    interfaces::return_ok_reponse( &politica )
}


pub async fn almacenar_texto(parametros: PoliticaDatosPersonales, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    db.insert(llave, &parametros.texto.into_bytes()[..])
	.map_err(|why| interfaces::error_response_map(Box::new(errors::StorableError::WriteError(why.to_string())) ))?;

    interfaces::return_ok_reponse( serde_json::json!({}) )
}

