use serde_derive::{Deserialize, Serialize};
use crate::{interfaces,errors};
use crate::model::Storable;
use crate::model::{
    sesion::Sesion,
    objetos_seguridad::{ObjetosSeguridad, RELACION_OBJETOS_PANTALLAS, Pantallas},
};

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct ConsultarInfoProducSuerte{
    cod_hda:Option<String>,
    fecha_inicial:String,
    fecha_final:String,    
}

pub async fn consultar_info_produc_suerte(parametros: ConsultarInfoProducSuerte, sesion: Sesion, db: std::sync::Arc<sled::Db>, config: crate::utils::ArchivoConfiguracion) -> Result<impl warp::Reply, warp::Rejection> {

    #[derive(Serialize,Deserialize,Debug)]
    pub struct ConsultaInfoProducSuerte{
        CPFS:Vec<String>,
        COD_HDA: Option<String>,
        F_INI: String,
        F_FIN: String,
        API_KEY:String,
    }

    #[derive(Serialize,Deserialize,Debug)]
    pub struct FilaConsultaInfoProducSuerte{
        SUERTE: String,
        FECHA_ULTCOL: String,
        AREA_COSECHADA: String,
        TCH: String,
        RDTO: String,
        ESTADO_CORTE: String,
        FAZENDA: String,
        AREA_TOTAL: String,
        SALDO_AREA: String,
        NCORTES: String,
        VARIEDAD: String,
        EDAD: String,
        TC:String,
        TCHM: String,
        SACPC:String
    }

    let mut usuario = sesion.usuario();
    usuario.refresh_instance(&db);
    
    let peticion = ConsultaInfoProducSuerte{
        COD_HDA: parametros.cod_hda,
        CPFS: usuario.nits(),
        API_KEY: config.api_key,
        F_INI : parametros.fecha_inicial,
        F_FIN : parametros.fecha_final,
    };


    let mut res : Vec<FilaConsultaInfoProducSuerte> = crate::request_proxy!(
	"{url_proxy}/info_produc_suerte",
	config.url_proxy,
	peticion,
	Vec<FilaConsultaInfoProducSuerte>,
    120
    );

    for fila in res.iter_mut(){
	fila.AREA_TOTAL = crate::utils::redondear_str_float(&fila.AREA_TOTAL,2);
	fila.AREA_COSECHADA = crate::utils::redondear_str_float(&fila.AREA_COSECHADA,2);
	fila.EDAD = crate::utils::redondear_str_float(&fila.EDAD,2);
	fila.TC = crate::utils::redondear_str_float(&fila.TC,2);
	fila.TCH = crate::utils::redondear_str_float(&fila.TCH,2);
	fila.TCHM = crate::utils::redondear_str_float(&fila.TCHM,2);
	fila.RDTO = crate::utils::redondear_str_float(&fila.RDTO,2);
	fila.SACPC = crate::utils::redondear_str_float(&fila.SACPC,2);
	fila.SALDO_AREA = crate::utils::redondear_str_float(&fila.SALDO_AREA,2);
    }

    
    interfaces::return_ok_reponse(&res)
}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct TotalesInfoProducSuerte{
    cod_hda:Option<String>,
    fecha_inicial:String,
    fecha_final:String,
}

pub async fn totales_info_produc_suerte(parametros: TotalesInfoProducSuerte, sesion: Sesion, db: std::sync::Arc<sled::Db>, config: crate::utils::ArchivoConfiguracion) -> Result<impl warp::Reply, warp::Rejection> {

    #[derive(Serialize,Deserialize,Debug)]
    pub struct TotalesInfoProducSuerte{
        CPFS:Vec<String>,
        COD_HDA: Option<String>,
        F_INI: String,
        F_FIN: String,
        API_KEY:String,
    }

    #[derive(Serialize,Deserialize,Debug)]
    pub struct RespuestaTotalesInfoProducSuerte{
        HACIENDA: String,
        AREA_TOTAL: String,
        AREA_COS: String,
        EDAD: String,
        TC: String,
        TCH: String,
        TCHM: String,
        RDTO: String,
        SACP: String,
    }

    let mut usuario = sesion.usuario();
    usuario.refresh_instance(&db);
    
    let peticion = TotalesInfoProducSuerte{
        COD_HDA: parametros.cod_hda,
        CPFS: usuario.nits(),
        API_KEY: config.api_key,
        F_INI : parametros.fecha_inicial,
        F_FIN : parametros.fecha_final,
    };


    let res : RespuestaTotalesInfoProducSuerte = crate::request_proxy!(
	"{url_proxy}/totales_info_produc_suerte",
	config.url_proxy,
	peticion,
	RespuestaTotalesInfoProducSuerte,
    120
    );
    
    interfaces::return_ok_reponse(&res)

}

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct GenerarInfoPdf{
    usuario_id: String,
}

pub async fn generar_info_pdf(parametros: GenerarInfoPdf, sesion: Sesion, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {
    interfaces::return_ok_reponse( serde_json::json!(&false) )
}
