use crate::interfaces;
use serde::{Serialize, Deserialize};
use nanoid::nanoid;
use warp::filters::multipart::{FormData, Part};
use warp::Buf;
use crate::errors;
use futures_util::TryStreamExt;
use crate::model::{
    sesion::Sesion,
};
const llave : &str = "viculacion_juridica";


pub async fn cargar_pdf(form:FormData, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    let parts: Vec<Part> = form.try_collect().await.map_err(|e| {
        interfaces::error_response_map( Box::new(errors::ProcesamientoDocumentos::DatosMultipartInvalidos(e.to_string())) )
    })?;
    
    for mut p in parts {
        if p.name() == "archivo" {
	    
	    db.insert(llave, p
		.data()
		.await
		.ok_or( "Parte del 'contenido del archivo' no pudo ser encontrada al cargar" )
		.map_err(|e| {
		    eprintln!("Error leyendo archivo cargado: {}", e);
		    interfaces::error_response_map( Box::new( errors::ProcesamientoDocumentos::DatosMultipartNoEncontrados("archivo".to_string(), e.to_string() ) ) )
		})?
		.unwrap()
		.bytes())
		.map_err(|why| interfaces::error_response_map(Box::new(errors::StorableError::WriteError(why.to_string())) ))?;

	}
    }


    interfaces::return_ok_reponse( serde_json::json!({}) )

}

#[derive(Serialize)]
pub struct ObtenerPdf{
    ruta: String,
}

pub async fn obtener_pdf(db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    let bytes = db.get(llave)
	.map_err(|why| interfaces::error_response_map(Box::new(errors::StorableError::ReadError(why.to_string())) ))?
	.ok_or(interfaces::error_response_map(Box::new(errors::StorableError::NotFound(llave.to_string())) ))?;
    
    let id = nanoid!();
    let path = crate::tmppdffmt!(id);
    std::fs::write(&path, bytes).map_err(|why| interfaces::error_response_map(Box::new(errors::StorableError::WriteError(why.to_string())) ))?;
	
    interfaces::return_ok_reponse( &ObtenerPdf{
	ruta: crate::tmpdownloadpdffmt!(format!(crate::pdffmt!(), id)),
    })
    
}
