use std::default::Default;
use serde::{Serialize, Deserialize};
use crate::{errors, interfaces};

#[derive(Deserialize)]
pub struct Listar{
    filtro: Option<String>
}


pub async fn listar(parametros: Listar, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    let mut salida = String::new();

    if let Some(filtro) = parametros.filtro{

	for result in db.scan_prefix(filtro.as_bytes()){

	    if let Ok((key,bytes)) = result{

		let mut cursor = std::io::Cursor::new(bytes);
		
		let value: rmpv::Value = rmpv::decode::read_value(&mut cursor)
		    .unwrap_or(rmpv::Value::Nil);
		
		salida.push_str(&format!("\n{} => {:?}\n\n",std::str::from_utf8(&key[..]).unwrap(), value));
		if salida.len() > 5_000_000{
		    break;
		}
		
	    }
	    
	    
	}

	
    }else{

	for result in db.iter(){

	    if let Ok((key,bytes)) = result{

		let mut cursor = std::io::Cursor::new(bytes);
		
		let value: rmpv::Value = rmpv::decode::read_value(&mut cursor)
		    .unwrap_or(rmpv::Value::Nil);
		
		salida.push_str(&format!("\n{} => {:?}\n\n",std::str::from_utf8(&key[..]).unwrap(), value));
		if salida.len() > 5_000_000{
		    break;
		}
		
	    }
	    
	    
	}

	
    }
    
    
    
    
    interfaces::return_ok_reponse( salida )
}

#[derive(Deserialize)]
pub struct Delete{
    id: String,
}


pub async fn borrar(parametros: Delete, db: std::sync::Arc<sled::Db>) -> Result<impl warp::Reply, warp::Rejection> {

    db.remove(parametros.id.as_bytes())
	.map_err(|why| interfaces::error_response_map(Box::new(why)))?;
    
    interfaces::return_ok_reponse( &true )
}

