use serde_derive::{Deserialize, Serialize};
use crate::{interfaces,errors};
use crate::model::Storable;
use crate::model::{
    sesion::Sesion
};

#[derive(Deserialize, Serialize, Clone, Debug)]
pub struct ListarCronologico{
    cod_hda: Option<String>,
}

pub async fn listar_cronologico(parametros: ListarCronologico, sesion: Sesion, db: std::sync::Arc<sled::Db>, config: crate::utils::ArchivoConfiguracion) -> Result<impl warp::Reply, warp::Rejection> {

    #[derive(Serialize,Deserialize,Debug)]
    pub struct ConsultaCronologico{
        CPFS: Vec<String>,
        COD_HDA: Option<String>,
        API_KEY:String,
    }

    #[derive(Serialize,Deserialize,Debug)]
    pub struct FilaConsultaCronologico{
        SUERTE: String,
        AREA: String,
        EDAD: String,
        FECHA_UC: String,
        VARIEDAD: String,
        NCORTE: String,
        FECHA_SIEMBRA: String,
        HACIENDA: String,
        OCUP: String,
        TCH_EST: String,
        DIST_SURC: String,
        DISTANCIA: String,
        ZONA_AGROC: String,
    }

    let mut usuario = sesion.usuario();
    usuario.refresh_instance(&db);
    
    let peticion = ConsultaCronologico{
        COD_HDA: parametros.cod_hda,
        CPFS: usuario.nits(),
        API_KEY: config.api_key,
    };

    

    let mut res : Vec<FilaConsultaCronologico> = crate::request_proxy!(
	"{url_proxy}/cronologico",
	config.url_proxy,
	peticion,
	Vec<FilaConsultaCronologico>,
    40
    );

    for fila in res.iter_mut(){
	fila.AREA = crate::utils::redondear_str_float(&fila.AREA,2);
	fila.EDAD = crate::utils::redondear_str_float(&fila.EDAD,2);
	fila.DIST_SURC = crate::utils::redondear_str_float(&fila.DIST_SURC,2);
	fila.DISTANCIA = crate::utils::redondear_str_float(&fila.DISTANCIA,2);
	fila.NCORTE = crate::utils::redondear_str_float(&fila.NCORTE,0);
    fila.TCH_EST = crate::utils::redondear_str_float(&fila.TCH_EST,1);
    }

    
    interfaces::return_ok_reponse(&res)

}

