use std::default::Default;
use serde::{Serialize, Deserialize};
use crate::{errors, interfaces, model::{Storable, sesion::Sesion}};
use crate::model::asistencia_tecnica::{
    CategoriaAsistencia,
    AsistenciaTecnica
};

#[derive(Deserialize)]
pub struct RecuperarTexto{
    categoria: CategoriaAsistencia,
}

#[derive(Serialize)]
pub struct ResultadoRecuperarTexto{
    texto: String,
}


pub async fn recuperar_texto(parametros:RecuperarTexto, sesion: Sesion, db: std::sync::Arc<sled::Db>, config: crate::utils::ArchivoConfiguracion) -> Result<impl warp::Reply, warp::Rejection> {

    let hash = AsistenciaTecnica::hash_categoria(&parametros.categoria);

   
    let respuesta : ResultadoRecuperarTexto;
    
    if let Some(asistencia) = AsistenciaTecnica::load(&db, &hash).map_err(|why| interfaces::error_response_map(why))? {

	respuesta = ResultadoRecuperarTexto{
	    texto: asistencia.texto(),
	}

    } else {

	respuesta = ResultadoRecuperarTexto{
	    texto: "".to_string(),
	}
	
    }

    interfaces::return_ok_reponse( &respuesta )
}


#[derive(Deserialize)]
pub struct AlmacenarTexto{
    categoria: CategoriaAsistencia,
    texto: String,
}


pub async fn almacenar_texto(parametros:AlmacenarTexto, sesion: Sesion, db: std::sync::Arc<sled::Db>, config: crate::utils::ArchivoConfiguracion) -> Result<impl warp::Reply, warp::Rejection> {

    let hash = AsistenciaTecnica::hash_categoria(&parametros.categoria);
    
    let respuesta : ResultadoRecuperarTexto;
    
    if let Some(ref mut asistencia) = AsistenciaTecnica::load(&db, &hash).map_err(|why| interfaces::error_response_map(why))? {

	asistencia.set_texto(parametros.texto);
	asistencia.store(&db,&sesion)
	    .map_err(|why| interfaces::error_response_map(why))?;

    } else {

	let mut nueva_asistencia = AsistenciaTecnica::new();
	nueva_asistencia.set_categoria(parametros.categoria);
	nueva_asistencia.set_texto(parametros.texto);
	nueva_asistencia.store(&db,&sesion)
	    .map_err(|why| interfaces::error_response_map(why))?;

	
    }

    interfaces::return_ok_reponse( &serde_json::json!( {} ) )

}

