use thiserror::Error;


#[derive(Error, Debug)]
pub enum ErroresConfiguracion {
    #[error("C001|La codificacion de caracteres del archivo de configuracion es incorrecta")]
    CodificacionUTF8Incorrecta,
    #[error("C002|No fue posible la lectura del archivo de configuracion. Causa: {0}")]
    FallaLecturaArchivo(String),
    #[error("C003|Falla interpretacion de formato TOML en el archivo. Causa: {0}")]
    FallaInterpretacionTOML(String),
    #[error("C004|Error desconocido")]
    Unknown,
    #[error("C005|Configuracion de cron '{cron}' incorrecta. Causa: {motivo}")]
    FallaInterpretacionCron{cron: String, motivo: String},

}

#[derive(Error, Debug)]
pub enum ErroresNotificacionesPush {
    #[error("F000|La confioguracion del servidor firebase es incorrecta. Motivo : {motivo}")]
    ConfiguracionFirebaseIncorrecta{motivo: String},
    #[error("F001|Error al intentar construir la peticion HTTP a firebase. Motivo : {motivo}")]
    ErrorCreandoSolicitud{motivo: String},
    #[error("F002|Falla al enviar mensaje a firebase. Motivo: {motivo}")]
    ErrorEnvioMensajeAFirebase{motivo: String},
    #[error("F003|Falla al intentar decodificar mensaje del servidor firebase. Motivo: {motivo}. Contenido respuesta: {}")]
    ErrorLeyendoResultado{motivo: String, contenido_respuesta: String},

}


#[derive(Error, Debug)]
pub enum StorableError {
    #[error("S001|Error leyendo datos del almacenamiento: {0}")]
    ReadError(String),
    #[error("S002|Error Escribiendo datos del almacenamiento: {0}")]
    WriteError(String),
    #[error("S003|Error importando datos del almacenamiento: {0}")]
    ImportError(String),
    #[error("S004|Error exportando datos del almacenamiento: {0}")]
    ExportError(String),
    #[error("S005|Datos no encontrados en el almacenamiento: {0}")]
    NotFound(String),
    #[error("S006|El este dato se encuentra repetido: {0}")]
    DuplicateRecord(String, String),
    #[error("S007|Error desconocido")]
    Unknown,
}

#[derive(Error, Debug)]
pub enum FallaProxy {
    #[error("Q001|Falla al intentar enviar peticion a SICAP. Motivo interno {motivo_interno}")]
    ErrorCreandoSolicitud{motivo_interno: String},
    #[error("Q002|Error leyendo resultado de SICAP ({peticion}). Motivo: {motivo_interno}")]
    ErrorLeyendoResultado{peticion:String, motivo_interno: String},
    #[error("Q003|Error de conexion a la base de datos. Por favor intente nuevamente. Motivo interno: {motivo_interno}")]
    ErrorConexionBaseDatos{motivo_interno: String},
    #[error("Q004|Error consultado SICAP: {motivo_interno}. Llamado: {peticion}")]
    ErrorRemoto{peticion:String, motivo_interno: String},
}

#[derive(Error, Debug)]
pub enum AuthenticationError {
    #[error("A001|Usuario/Clave de Acceso invalida(s)")]
    InvalidCredentials,
    #[error("A002|Fallo al intentar terminar la sesion.")]
    LogoffFailed,
    #[error("A003|Maxima cantidad de intentos de ingreso incorrectos excedido")]
    MaxLoginAttemptExceeded,
    #[error("A004|Usuario Inactivo")]
    InvalidUser,
    #[error("A005|Ya existe un usuario con el mismo correo ingresado.")]
    DuplicacionEmail,
    #[error("A006|El Usuario {user} está inactivo. Por favor comuníquese con el administrador.")]
    UsuarioInactivo{user: String},
    #[error("A007|El usuario {user} está eliminado. Por favor comuníquese con el administrador.")]
    UsuarioEliminado{user: String},

}


#[derive(Error, Debug)]
pub enum PasswordRefreshFail {
    #[error("P001|El correo electronico \"{0}\" no se encuentra registrado en el sistema")]
    InvalidEmailForRefreshingPassword(String),
    #[error("P002|clave dinamica incorrecta.")]
    InvalidDynamicPassword,
    #[error("P003|El token de refresco de clavede acceso {0} no existe.")]
    PasswordRefreshTokenNotFound(String),
    #[error("P004|No fue posible construir el cuerpo del correo a enviar. Motivo: {motivo}.")]
    ErrorConstruyendoCuerpoCorreo{motivo:String},
    #[error("P005|Error intentando crear conexion TLS. Motivo: {motivo}.")]
    ErrorProtocoloTLS{ motivo:String},
    #[error("P006|Error conectado al servidor SMTP. Motivo: {motivo}.")]
    ErrorConexionServidorSMTP{ motivo:String },
    #[error("P006|Error enviando correo via servidor SMTP. Motivo: {motivo}.")]
    ErrorEnviandoCorreo{ motivo:String }
}

#[derive(Error, Debug)]
pub enum ProcesamientoDocumentos {
    #[error("R001|Esta carga de archivos es 'multipart' los datos enviados no parecen respetar la especificacion. ver mas en https://www.w3.org/Protocols/rfc1341/7_2_Multipart.html. Motivo Interno: {0}")]
    DatosMultipartInvalidos(String),
    #[error("R002|Tipo de archivo invalido. Solo es posible cargar arhivos tipo MIME application/pdf y application/zip. Tipo de archivo cargado '{0}'")]
    TipoArchivoIncorrecto(String),
    #[error("R003|La parte multipart llamada '{0}' no contiene datos. Motivo interno: {1}")]
    DatosMultipartNoEncontrados(String, String),
    #[error("R004|Error de conversion de datos. el dato '{0}' no pudo ser convertido ubicacion {1}:{2}. Motivo Interno: {3}")]
    ErrorConversionDatos(String, String, String, String),
    #[error("R005|Orden de procesamiento de documentos {0} no encontrada")]
    OrdenProcesamientoNoEncontrada(String),
    #[error("R006|No es posible escribir el archivo temporal {nombre_archivo}, Motivo Interno: {motivo_interno}")]
    ImposibleEscribirArchivoTemporal{nombre_archivo: String, motivo_interno: String},
    #[error("R007|Falla descomprimiendo archivo {0}, Motivo Interno: {1}")]
    FallaDescomprimiendoArchivo(String, String),
    #[error("R008|Falla distribuyendo documento: {0}. Motivo interno : {1}")]
    FallaDistribucion(String, String),
    #[error("R009|Fallas detectandas siguientes páginas: {numeros_paginas}.")]
    FallaLecturaCampos{numeros_paginas:String},
    #[error("R010|No es posible encontrar el archivo fuente en la ruta {nombre_archivo}")]
    ArchivoFuenteNoEncontrado{nombre_archivo: String},
    #[error("R011|No es posible obtener bloqueo sobre el listado de ordenes de procesamiento. Motivo Interno: {motivo_interno}")]
    EstadoOrdenesNoSePuedeBloquear{motivo_interno: String},
    #[error("R012|Documento no encontrado usando llaves '{llaves}'")]
    DocumentoNoEncontrado{llaves: String},
    #[error("R012|Fallo generando llaves de documento. Origen: '{origen}'. Especificacion llaves: {especificacion_llaves}")]
    FalloGenerandoLlaveDocumento{origen: String, especificacion_llaves: String},


}

#[derive(Error, Debug)]
pub enum GeneracionReportes {
    #[error("G001|No se puede crear archivo de reporte en carpeta temporal de nombre {nombre_archivo}. Motivo interno : {motivo}")]
    NoSepudeCrearTemporalReporte{nombre_archivo: String,motivo: String},
    #[error("G002|No se puede escribir la linea en el archivo : {nombre_archivo}. Motivo interno : {motivo}")]
    NoSepuedeEscribirLinea{nombre_archivo: String,motivo: String},
    #[error("G003|No se puede cerra el archivo : {nombre_archivo}. Motivo interno : {motivo}")]
    NoSepuedeCerrarArchivo{nombre_archivo: String,motivo: String},
    #[error("G004|No se puede obtener el nombre del archivo : {nombre_archivo}. Motivo interno : {motivo}")]
    NoSepuedeObtenerNombreArchivo{nombre_archivo: String,motivo: String},
    #[error("G005|No se puede obtener al ruta del el archivo : {nombre_archivo}. Motivo interno : {motivo}")]
    NoSepuedeObtenerRutaArchivo{nombre_archivo: String,motivo: String},
    #[error("G006|No se puede cargar el usuario para el reporte : {usuario}. Motivo interno : {motivo}")]
    NoSepuedeCargarusuario{usuario: String,motivo: String},

}

#[derive(Error, Debug)]
pub enum Converciones {
    #[error("K001|No es posible encontrar el archivo fuente en la ruta {nombre_archivo} para realizar la conversion")]
    ArchivoFuenteNoEncontrado{nombre_archivo: String},
    #[error("K002|El comando gs (GhostScript) no esta presente en el sistema, no es posible continuar el proceso de conversion del PDF. Motivo Interno: {motivo_interno}")]
    GhostScriptNoPresente{motivo_interno: String},
    #[error("K003|Falla al ejecutar conversion de PDF '{pdf}' a texto '{archivo_texto}' utilizando gs (GhostScript). Motivo interno: {motivo_interno}")]
    FalloEjecucionGhostScript{pdf: String, archivo_texto: String, motivo_interno: String},
    #[error("K004|El comando pdfseparate (poppler-utils) no esta presente en el sistema, no es posible continuar el proceso de division del PDF. Motivo Interno: {motivo_interno}")]
    PdfSeparateNoPresente{motivo_interno: String},
    #[error("K006|Falla al ejecutar separacion de PDF '{pdf}' a multiples archivos individuales por hoja utilizando pdfseparate (poppler-utils). Motivo interno: {motivo_interno}")]
    FalloEjecucionPdfSeparate{pdf: String,  motivo_interno: String},
    #[error("K007|Falla al intentar encontrar los archivos separados generados para el PDF '{pdf}'. Patron de busqueda usado '{patron_busqueda}'. Motivo interno: {motivo_interno}")]
    FalloBusquedaArchivosSeparados{pdf: String,  patron_busqueda: String, motivo_interno: String},
    #[error("K008|Falla al intentar procesar una fecha desde el texto '{origen}'. Motivo interno: {motivo}")]
    FalloInterpretandoFecha{origen: String, motivo: String},
    #[error("K009|Falla intentado interpretar nombre archivo. ruta orignal '{origen}'")]
    FalloInterpretandoNombreArchivo{origen: String},

}
